/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.router.KeepAliveWrite;
import io.netty.handler.codec.http.router.MethodRouted;
import io.netty.handler.codec.http.router.MethodRouter;
import jauter.Routed;

@ChannelHandler.Sharable
public abstract class AbstractHandler<T, RouteLike extends MethodRouter<T, RouteLike>>
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final byte[] CONTENT_404 = "Not Found".getBytes();
    private final MethodRouter<T, RouteLike> router;

    public AbstractHandler(MethodRouter<T, RouteLike> methodRouter) {
        this.router = methodRouter;
    }

    public MethodRouter<T, RouteLike> router() {
        return this.router;
    }

    protected abstract void routed(ChannelHandlerContext var1, MethodRouted<T> var2) throws Exception;

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) throws Exception {
        QueryStringDecoder queryStringDecoder;
        if (HttpHeaderUtil.is100ContinueExpected((HttpMessage)httpRequest)) {
            channelHandlerContext.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            return;
        }
        HttpMethod httpMethod = httpRequest.method();
        Routed routed = this.router.route(httpMethod, (queryStringDecoder = new QueryStringDecoder(httpRequest.uri())).path());
        if (routed == null) {
            this.respondNotFound(channelHandlerContext, httpRequest);
            return;
        }
        MethodRouted<Object> methodRouted = new MethodRouted<Object>(routed.target(), routed.notFound(), httpRequest, queryStringDecoder.path(), routed.params(), queryStringDecoder.parameters());
        this.routed(channelHandlerContext, methodRouted);
    }

    protected void respondNotFound(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, Unpooled.wrappedBuffer((byte[])CONTENT_404));
        HttpHeaders httpHeaders = defaultFullHttpResponse.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        HttpHeaderUtil.setContentLength((HttpMessage)defaultFullHttpResponse, (long)CONTENT_404.length);
        KeepAliveWrite.flush(channelHandlerContext, httpRequest, (HttpResponse)defaultFullHttpResponse);
    }
}

