/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.router.MethodlessRouter;
import io.netty.handler.codec.http.router.PathPattern;
import io.netty.handler.codec.http.router.RouteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Router<T> {
    private final Map<HttpMethod, MethodlessRouter<T>> routers = new HashMap<HttpMethod, MethodlessRouter<T>>();
    private final MethodlessRouter<T> anyMethodRouter = new MethodlessRouter();
    private T notFound;

    public T notFound() {
        return this.notFound;
    }

    public int size() {
        int n = this.anyMethodRouter.size();
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            n += methodlessRouter.size();
        }
        return n;
    }

    public Router<T> addRouteFirst(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRouteFirst(string, t);
        return this;
    }

    public Router<T> addRoute(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRoute(string, t);
        return this;
    }

    public Router<T> addRouteLast(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRouteLast(string, t);
        return this;
    }

    public Router<T> notFound(T t) {
        this.notFound = t;
        return this;
    }

    private MethodlessRouter<T> getMethodlessRouter(HttpMethod httpMethod) {
        if (httpMethod == null) {
            return this.anyMethodRouter;
        }
        MethodlessRouter<T> methodlessRouter = this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = new MethodlessRouter();
            this.routers.put(httpMethod, methodlessRouter);
        }
        return methodlessRouter;
    }

    public void removePathPattern(String string) {
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            methodlessRouter.removePathPattern(string);
        }
        this.anyMethodRouter.removePathPattern(string);
    }

    public void removeTarget(T t) {
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            methodlessRouter.removeTarget(t);
        }
        this.anyMethodRouter.removeTarget(t);
    }

    public RouteResult<T> route(HttpMethod httpMethod, String string) {
        MethodlessRouter<T> methodlessRouter = this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = this.anyMethodRouter;
        }
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(string);
        String[] stringArray = this.decodePathTokens(string);
        RouteResult<T> routeResult = methodlessRouter.route(string, queryStringDecoder.path(), stringArray);
        if (routeResult != null) {
            return new RouteResult<T>(string, queryStringDecoder.path(), routeResult.pathParams(), queryStringDecoder.parameters(), routeResult.target());
        }
        if (methodlessRouter != this.anyMethodRouter && (routeResult = this.anyMethodRouter.route(string, queryStringDecoder.path(), stringArray)) != null) {
            return new RouteResult<T>(string, queryStringDecoder.path(), routeResult.pathParams(), queryStringDecoder.parameters(), routeResult.target());
        }
        if (this.notFound != null) {
            return new RouteResult<T>(string, queryStringDecoder.path(), Collections.<String, String>emptyMap(), queryStringDecoder.parameters(), this.notFound);
        }
        return null;
    }

    private String[] decodePathTokens(String string) {
        int n = string.indexOf("?");
        String string2 = n >= 0 ? string.substring(0, n) : string;
        String[] stringArray = PathPattern.removeSlashesAtBothEnds(string2).split("/");
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            stringArray2[i] = QueryStringDecoder.decodeComponent((String)string3);
        }
        return stringArray2;
    }

    public Set<HttpMethod> allowedMethods(String string) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(string);
        String[] stringArray = PathPattern.removeSlashesAtBothEnds(queryStringDecoder.path()).split("/");
        if (this.anyMethodRouter.anyMatched(stringArray)) {
            return this.allAllowedMethods();
        }
        HashSet<HttpMethod> hashSet = new HashSet<HttpMethod>(this.routers.size());
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> entry : this.routers.entrySet()) {
            MethodlessRouter<T> methodlessRouter = entry.getValue();
            if (!methodlessRouter.anyMatched(stringArray)) continue;
            HttpMethod httpMethod = entry.getKey();
            hashSet.add(httpMethod);
        }
        return hashSet;
    }

    public Set<HttpMethod> allAllowedMethods() {
        if (this.anyMethodRouter.size() > 0) {
            HashSet<HttpMethod> hashSet = new HashSet<HttpMethod>(9);
            hashSet.add(HttpMethod.CONNECT);
            hashSet.add(HttpMethod.DELETE);
            hashSet.add(HttpMethod.GET);
            hashSet.add(HttpMethod.HEAD);
            hashSet.add(HttpMethod.OPTIONS);
            hashSet.add(HttpMethod.PATCH);
            hashSet.add(HttpMethod.POST);
            hashSet.add(HttpMethod.PUT);
            hashSet.add(HttpMethod.TRACE);
            return hashSet;
        }
        return new HashSet<HttpMethod>(this.routers.keySet());
    }

    public String uri(HttpMethod httpMethod, T t, Object ... objectArray) {
        String string;
        MethodlessRouter<T> methodlessRouter;
        MethodlessRouter<T> methodlessRouter2 = methodlessRouter = httpMethod == null ? this.anyMethodRouter : this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = this.anyMethodRouter;
        }
        if ((string = methodlessRouter.uri(t, objectArray)) != null) {
            return string;
        }
        return methodlessRouter != this.anyMethodRouter ? this.anyMethodRouter.uri(t, objectArray) : null;
    }

    public String uri(T t, Object ... objectArray) {
        Collection<MethodlessRouter<T>> collection = this.routers.values();
        for (MethodlessRouter<T> methodlessRouter : collection) {
            String string = methodlessRouter.uri(t, objectArray);
            if (string == null) continue;
            return string;
        }
        return this.anyMethodRouter.uri(t, objectArray);
    }

    public String toString() {
        Object object;
        int n = this.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        ArrayList<String> arrayList3 = new ArrayList<String>(n);
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> entry : this.routers.entrySet()) {
            object = entry.getKey();
            MethodlessRouter<T> methodlessRouter = entry.getValue();
            Router.aggregateRoutes(object.toString(), methodlessRouter.first().routes(), arrayList, arrayList2, arrayList3);
            Router.aggregateRoutes(object.toString(), methodlessRouter.other().routes(), arrayList, arrayList2, arrayList3);
            Router.aggregateRoutes(object.toString(), methodlessRouter.last().routes(), arrayList, arrayList2, arrayList3);
        }
        Router.aggregateRoutes("*", this.anyMethodRouter.first().routes(), arrayList, arrayList2, arrayList3);
        Router.aggregateRoutes("*", this.anyMethodRouter.other().routes(), arrayList, arrayList2, arrayList3);
        Router.aggregateRoutes("*", this.anyMethodRouter.last().routes(), arrayList, arrayList2, arrayList3);
        if (this.notFound != null) {
            arrayList.add("*");
            arrayList2.add("*");
            arrayList3.add(Router.targetToString(this.notFound));
        }
        int n2 = Router.maxLength(arrayList);
        int n3 = Router.maxLength(arrayList2);
        object = "%-" + n2 + "s  %-" + n3 + "s  %s\n";
        int n4 = (n2 + 1 + n3 + 1 + 20) * arrayList.size();
        StringBuilder stringBuilder = new StringBuilder(n4);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            String string2 = (String)arrayList2.get(i);
            String string3 = (String)arrayList3.get(i);
            stringBuilder.append(String.format((String)object, string, string2, string3));
        }
        return stringBuilder.toString();
    }

    private static <T> void aggregateRoutes(String string, Map<PathPattern, T> map, List<String> list, List<String> list2, List<String> list3) {
        for (Map.Entry<PathPattern, T> entry : map.entrySet()) {
            list.add(string);
            list2.add("/" + entry.getKey().pattern());
            list3.add(Router.targetToString(entry.getValue()));
        }
    }

    private static int maxLength(List<String> list) {
        int n = 0;
        for (String string : list) {
            int n2 = string.length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static String targetToString(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return object.toString();
    }

    public Router<T> CONNECT(String string, T t) {
        return this.addRoute(HttpMethod.CONNECT, string, t);
    }

    public Router<T> DELETE(String string, T t) {
        return this.addRoute(HttpMethod.DELETE, string, t);
    }

    public Router<T> GET(String string, T t) {
        return this.addRoute(HttpMethod.GET, string, t);
    }

    public Router<T> HEAD(String string, T t) {
        return this.addRoute(HttpMethod.HEAD, string, t);
    }

    public Router<T> OPTIONS(String string, T t) {
        return this.addRoute(HttpMethod.OPTIONS, string, t);
    }

    public Router<T> PATCH(String string, T t) {
        return this.addRoute(HttpMethod.PATCH, string, t);
    }

    public Router<T> POST(String string, T t) {
        return this.addRoute(HttpMethod.POST, string, t);
    }

    public Router<T> PUT(String string, T t) {
        return this.addRoute(HttpMethod.PUT, string, t);
    }

    public Router<T> TRACE(String string, T t) {
        return this.addRoute(HttpMethod.TRACE, string, t);
    }

    public Router<T> ANY(String string, T t) {
        return this.addRoute(null, string, t);
    }

    public Router<T> CONNECT_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.CONNECT, string, t);
    }

    public Router<T> DELETE_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.DELETE, string, t);
    }

    public Router<T> GET_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.GET, string, t);
    }

    public Router<T> HEAD_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.HEAD, string, t);
    }

    public Router<T> OPTIONS_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.OPTIONS, string, t);
    }

    public Router<T> PATCH_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.PATCH, string, t);
    }

    public Router<T> POST_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.POST, string, t);
    }

    public Router<T> PUT_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.PUT, string, t);
    }

    public Router<T> TRACE_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.TRACE, string, t);
    }

    public Router<T> ANY_FIRST(String string, T t) {
        return this.addRouteFirst(null, string, t);
    }

    public Router<T> CONNECT_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.CONNECT, string, t);
    }

    public Router<T> DELETE_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.DELETE, string, t);
    }

    public Router<T> GET_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.GET, string, t);
    }

    public Router<T> HEAD_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.HEAD, string, t);
    }

    public Router<T> OPTIONS_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.OPTIONS, string, t);
    }

    public Router<T> PATCH_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.PATCH, string, t);
    }

    public Router<T> POST_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.POST, string, t);
    }

    public Router<T> PUT_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.PUT, string, t);
    }

    public Router<T> TRACE_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.TRACE, string, t);
    }

    public Router<T> ANY_LAST(String string, T t) {
        return this.addRouteLast(null, string, t);
    }
}

