/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHandler404;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.Routed;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class Router
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final String ROUTER_HANDLER_NAME = Router.class.getName() + "_ROUTER_HANDLER";
    public static final String ROUTED_HANDLER_NAME = Router.class.getName() + "_ROUTED_HANDLER";
    protected final Map<HttpMethod, jauter.Router<Object>> routers = new HashMap<HttpMethod, jauter.Router<Object>>();
    protected final jauter.Router<Object> anyMethodRouter = new jauter.Router();
    protected final EventExecutorGroup group;
    protected final ChannelInboundHandler handler404;

    public Router() {
        this(null, (ChannelInboundHandler)new DefaultHandler404());
    }

    public Router(ChannelInboundHandler channelInboundHandler) {
        this(null, channelInboundHandler);
    }

    public Router(EventExecutorGroup eventExecutorGroup) {
        this(eventExecutorGroup, (ChannelInboundHandler)new DefaultHandler404());
    }

    public Router(EventExecutorGroup eventExecutorGroup, ChannelInboundHandler channelInboundHandler) {
        this.group = eventExecutorGroup;
        this.handler404 = channelInboundHandler;
    }

    public String name() {
        return ROUTER_HANDLER_NAME;
    }

    public Router pattern(HttpMethod httpMethod, String string, ChannelInboundHandler channelInboundHandler) {
        this.getRouter(httpMethod).pattern(string, (Object)channelInboundHandler);
        return this;
    }

    public Router pattern(HttpMethod httpMethod, String string, Class<? extends ChannelInboundHandler> clazz) {
        this.getRouter(httpMethod).pattern(string, clazz);
        return this;
    }

    public Router patternFirst(HttpMethod httpMethod, String string, ChannelInboundHandler channelInboundHandler) {
        this.getRouter(httpMethod).patternFirst(string, (Object)channelInboundHandler);
        return this;
    }

    public Router patternFirstFirst(HttpMethod httpMethod, String string, Class<? extends ChannelInboundHandler> clazz) {
        this.getRouter(httpMethod).patternFirst(string, clazz);
        return this;
    }

    public Router patternLast(HttpMethod httpMethod, String string, ChannelInboundHandler channelInboundHandler) {
        this.getRouter(httpMethod).patternLast(string, (Object)channelInboundHandler);
        return this;
    }

    public Router patternLast(HttpMethod httpMethod, String string, Class<? extends ChannelInboundHandler> clazz) {
        this.getRouter(httpMethod).patternLast(string, clazz);
        return this;
    }

    private jauter.Router<Object> getRouter(HttpMethod httpMethod) {
        if (httpMethod == null) {
            return this.anyMethodRouter;
        }
        jauter.Router router = this.routers.get(httpMethod);
        if (router == null) {
            router = new jauter.Router();
            this.routers.put(httpMethod, (jauter.Router<Object>)router);
        }
        return router;
    }

    public void removeTarget(Object object) {
        for (jauter.Router<Object> router : this.routers.values()) {
            router.removeTarget(object);
        }
        this.anyMethodRouter.removeTarget(object);
    }

    public void removePath(String string) {
        for (jauter.Router<Object> router : this.routers.values()) {
            router.removePath(string);
        }
        this.anyMethodRouter.removePath(string);
    }

    public void channelRead0(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) throws InstantiationException, IllegalAccessException {
        Map<String, String> map;
        Class clazz;
        Object object;
        Object object2;
        if (HttpHeaders.is100ContinueExpected((HttpMessage)httpRequest)) {
            channelHandlerContext.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            return;
        }
        HttpMethod httpMethod = httpRequest.getMethod();
        jauter.Router<Object> router = httpMethod == null ? this.anyMethodRouter : this.routers.get(httpMethod);
        ChannelInboundHandler channelInboundHandler = this.handler404;
        String string = httpRequest.getUri();
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(string);
        if (router != null) {
            object2 = router.route(queryStringDecoder.path());
            if (object2 != null) {
                object = object2.target();
                if (object instanceof ChannelInboundHandler) {
                    channelInboundHandler = (ChannelInboundHandler)object;
                } else {
                    clazz = (Class)object;
                    channelInboundHandler = (ChannelInboundHandler)clazz.newInstance();
                }
                map = object2.params();
            } else {
                map = new HashMap();
            }
        } else {
            map = new HashMap<String, String>();
        }
        ReferenceCountUtil.retain((Object)httpRequest);
        object2 = new Routed(httpRequest, queryStringDecoder.path(), map, queryStringDecoder.parameters());
        object = channelHandlerContext.pipeline();
        clazz = object.get(ROUTED_HANDLER_NAME);
        if (channelInboundHandler != clazz) {
            if (clazz == null) {
                if (this.group == null) {
                    object.addAfter(ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
                } else {
                    object.addAfter(this.group, ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
                }
            } else {
                object.replace((ChannelHandler)clazz, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
            }
        }
        channelHandlerContext.fireChannelRead(object2);
    }

    public String path(HttpMethod httpMethod, ChannelInboundHandler channelInboundHandler, Object ... objectArray) {
        return this._path(httpMethod, channelInboundHandler, objectArray);
    }

    public String path(HttpMethod httpMethod, Class<? extends ChannelInboundHandler> clazz, Object ... objectArray) {
        return this._path(httpMethod, clazz, objectArray);
    }

    private String _path(HttpMethod httpMethod, Object object, Object ... objectArray) {
        jauter.Router<Object> router = httpMethod == null ? this.anyMethodRouter : this.routers.get(httpMethod);
        return router == null ? null : router.path(object, new Object[0]);
    }

    public static ChannelFuture keepAliveWriteAndFlush(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            return channelHandlerContext.writeAndFlush((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        httpResponse.headers().set("Connection", (Object)"keep-alive");
        return channelHandlerContext.writeAndFlush((Object)httpResponse);
    }

    public static ChannelFuture keepAliveWriteAndFlush(Channel channel, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            return channel.writeAndFlush((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        httpResponse.headers().set("Connection", (Object)"keep-alive");
        return channel.writeAndFlush((Object)httpResponse);
    }
}

