/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.Routed;
import io.netty.util.concurrent.GenericFutureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class DefaultHandler404
extends SimpleChannelInboundHandler<Routed> {
    private static final byte[] CONTENT_404 = "404 Not Found".getBytes();

    public void channelRead0(ChannelHandlerContext channelHandlerContext, Routed routed) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, Unpooled.wrappedBuffer((byte[])CONTENT_404));
        HttpHeaders httpHeaders = defaultFullHttpResponse.headers();
        httpHeaders.set("Content-Type", (Object)"text/plain");
        httpHeaders.set("Content-Length", (Object)CONTENT_404.length);
        if (!HttpHeaders.isKeepAlive((HttpMessage)routed.request())) {
            channelHandlerContext.writeAndFlush((Object)defaultFullHttpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            httpHeaders.set("Connection", (Object)"keep-alive");
            channelHandlerContext.writeAndFlush((Object)defaultFullHttpResponse);
        }
    }
}

