/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.config;

import com.esotericsoftware.kryo.Kryo;
import com.twitter.chill.ClassRegistrar;
import com.twitter.chill.IKryoRegistrar;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.ReflectingDefaultRegistrar;
import com.twitter.chill.ReflectingRegistrar;
import com.twitter.chill.config.Config;
import com.twitter.chill.config.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class ReflectingInstantiator
extends KryoInstantiator {
    final boolean regRequired;
    final boolean skipMissing;
    final Class<? extends Kryo> kryoClass;
    final Class<? extends InstantiatorStrategy> instStratClass;
    final List<IKryoRegistrar> registrations;
    final List<ReflectingDefaultRegistrar> defaultRegistrations;
    public static final String prefix = "com.twitter.chill.config.reflectinginstantiator";
    public static final String KRYO_CLASS = "com.twitter.chill.config.reflectinginstantiator.kryoclass";
    public static final String KRYO_CLASS_DEFAULT = Kryo.class.getName();
    public static final String INSTANTIATOR_STRATEGY_CLASS = "com.twitter.chill.config.reflectinginstantiator.instantiatorstrategyclass";
    public static final String INSTANTIATOR_STRATEGY_CLASS_DEFAULT = StdInstantiatorStrategy.class.getName();
    public static final String REGISTRATIONS = "com.twitter.chill.config.reflectinginstantiator.registrations";
    public static final String DEFAULT_REGISTRATIONS = "com.twitter.chill.config.reflectinginstantiator.defaultregistrations";
    public static final String SKIP_MISSING = "com.twitter.chill.config.reflectinginstantiator.skipmissing";
    public static final boolean SKIP_MISSING_DEFAULT = false;
    public static final String REGISTRATION_REQUIRED = "com.twitter.chill.config.reflectinginstantiator.registrationrequired";
    public static final boolean REGISTRATION_REQUIRED_DEFAULT = false;

    public ReflectingInstantiator(Config config) throws ConfigurationException {
        this.regRequired = config.getBoolean(REGISTRATION_REQUIRED, false);
        this.skipMissing = config.getBoolean(SKIP_MISSING, false);
        try {
            this.kryoClass = Class.forName(config.getOrElse(KRYO_CLASS, KRYO_CLASS_DEFAULT));
            this.instStratClass = Class.forName(config.getOrElse(INSTANTIATOR_STRATEGY_CLASS, INSTANTIATOR_STRATEGY_CLASS_DEFAULT));
            this.registrations = this.buildRegistrars(config.get(REGISTRATIONS), false);
            this.defaultRegistrations = this.buildRegistrars(config.get(DEFAULT_REGISTRATIONS), true);
            this.newKryoWithEx();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationException(illegalAccessException);
        }
    }

    public ReflectingInstantiator(Iterable<ClassRegistrar> iterable, Iterable<ReflectingRegistrar> iterable2, Iterable<ReflectingDefaultRegistrar> iterable3) {
        this(Kryo.class, StdInstantiatorStrategy.class, iterable, iterable2, iterable3, false, false);
    }

    public ReflectingInstantiator(Class<? extends Kryo> clazz, Class<? extends InstantiatorStrategy> clazz2, Iterable<ClassRegistrar> iterable, Iterable<ReflectingRegistrar> iterable2, Iterable<ReflectingDefaultRegistrar> iterable3, boolean bl, boolean bl2) {
        this.kryoClass = clazz;
        this.instStratClass = clazz2;
        this.regRequired = bl;
        this.skipMissing = bl2;
        this.registrations = new ArrayList<IKryoRegistrar>();
        for (IKryoRegistrar iKryoRegistrar : iterable) {
            this.registrations.add(iKryoRegistrar);
        }
        for (IKryoRegistrar iKryoRegistrar : iterable2) {
            this.registrations.add(iKryoRegistrar);
        }
        this.defaultRegistrations = new ArrayList<ReflectingDefaultRegistrar>();
        for (ReflectingDefaultRegistrar reflectingDefaultRegistrar : iterable3) {
            this.defaultRegistrations.add(reflectingDefaultRegistrar);
        }
    }

    public void set(Config config) throws ConfigurationException {
        config.setBoolean(REGISTRATION_REQUIRED, this.regRequired);
        config.setBoolean(SKIP_MISSING, this.skipMissing);
        config.set(KRYO_CLASS, this.kryoClass.getName());
        config.set(INSTANTIATOR_STRATEGY_CLASS, this.instStratClass.getName());
        config.set(REGISTRATIONS, this.registrarsToString(this.registrations));
        config.set(DEFAULT_REGISTRATIONS, this.registrarsToString(this.defaultRegistrations));
    }

    protected Kryo newKryoWithEx() throws InstantiationException, IllegalAccessException {
        Kryo kryo = this.kryoClass.newInstance();
        kryo.setInstantiatorStrategy(this.instStratClass.newInstance());
        kryo.setRegistrationRequired(this.regRequired);
        for (IKryoRegistrar iKryoRegistrar : this.registrations) {
            iKryoRegistrar.apply(kryo);
        }
        for (IKryoRegistrar iKryoRegistrar : this.defaultRegistrations) {
            iKryoRegistrar.apply(kryo);
        }
        return kryo;
    }

    @Override
    public Kryo newKryo() {
        try {
            return this.newKryoWithEx();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    protected List<? extends IKryoRegistrar> buildRegistrars(String string, boolean bl) throws ConfigurationException {
        ArrayList<IKryoRegistrar> arrayList = new ArrayList<IKryoRegistrar>();
        if (string == null) {
            return arrayList;
        }
        for (String string2 : string.split(":")) {
            String[] stringArray = string2.split(",");
            try {
                switch (stringArray.length) {
                    case 1: {
                        if (bl) {
                            throw new ConfigurationException("default serializers require class and serializer: " + string);
                        }
                        arrayList.add(new ClassRegistrar(Class.forName(stringArray[0])));
                        break;
                    }
                    case 2: {
                        Class<?> clazz = Class.forName(stringArray[0]);
                        Class<?> clazz2 = Class.forName(stringArray[1]);
                        if (bl) {
                            arrayList.add(new ReflectingDefaultRegistrar(clazz, clazz2));
                            break;
                        }
                        arrayList.add(new ReflectingRegistrar(clazz, clazz2));
                        break;
                    }
                    default: {
                        throw new ConfigurationException(string + " is not well-formed.");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.skipMissing) {
                    System.err.println("Could not find serialization or class for " + stringArray[1] + ". Skipping registration.");
                    continue;
                }
                throw new ConfigurationException(classNotFoundException);
            }
        }
        return arrayList;
    }

    protected String registrarsToString(Iterable<? extends IKryoRegistrar> iterable) throws ConfigurationException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (IKryoRegistrar iKryoRegistrar : iterable) {
            IKryoRegistrar iKryoRegistrar2;
            if (!bl) {
                stringBuilder.append(":");
            }
            bl = false;
            String string = null;
            if (iKryoRegistrar instanceof ClassRegistrar) {
                iKryoRegistrar2 = (ClassRegistrar)iKryoRegistrar;
                string = ((ClassRegistrar)iKryoRegistrar2).getRegisteredClass().getName();
            } else if (iKryoRegistrar instanceof ReflectingRegistrar) {
                iKryoRegistrar2 = (ReflectingRegistrar)iKryoRegistrar;
                string = ((ReflectingRegistrar)iKryoRegistrar2).getRegisteredClass().getName() + "," + ((ReflectingRegistrar)iKryoRegistrar2).getSerializerClass().getName();
            } else if (iKryoRegistrar instanceof ReflectingDefaultRegistrar) {
                iKryoRegistrar2 = (ReflectingDefaultRegistrar)iKryoRegistrar;
                string = ((ReflectingDefaultRegistrar)iKryoRegistrar2).getRegisteredClass().getName() + "," + ((ReflectingDefaultRegistrar)iKryoRegistrar2).getSerializerClass().getName();
            } else {
                throw new ConfigurationException("Unknown type of reflecting registrar: " + iKryoRegistrar.getClass().getName());
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.kryoClass.hashCode() ^ this.registrations.hashCode() ^ this.defaultRegistrations.hashCode();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof ReflectingInstantiator) {
            ReflectingInstantiator reflectingInstantiator = (ReflectingInstantiator)object;
            return this.regRequired == reflectingInstantiator.regRequired && this.skipMissing == reflectingInstantiator.skipMissing && this.kryoClass.equals(reflectingInstantiator.kryoClass) && this.instStratClass.equals(reflectingInstantiator.instStratClass) && this.registrations.equals(reflectingInstantiator.registrations) && this.defaultRegistrations.equals(reflectingInstantiator.defaultRegistrations);
        }
        return false;
    }
}

