/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention.resource;

import com.impetus.annovention.Filter;
import com.impetus.annovention.resource.ResourceIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileIterator
implements ResourceIterator {
    private List<File> files = new ArrayList<File>();
    private int index = 0;

    public ClassFileIterator(File file, Filter filter) {
        try {
            ClassFileIterator.init(this.files, file, filter);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void init(List<File> list, File file, Filter filter) throws Exception {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                ClassFileIterator.init(list, fileArray[i], filter);
                continue;
            }
            if (filter != null && !filter.accepts(fileArray[i].getAbsolutePath())) continue;
            list.add(fileArray[i]);
        }
    }

    @Override
    public final InputStream next() {
        if (this.index >= this.files.size()) {
            return null;
        }
        File file = this.files.get(this.index++);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    @Override
    public void close() {
    }
}

