/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention;

import com.impetus.annovention.Filter;
import com.impetus.annovention.listener.ClassAnnotationDiscoveryListener;
import com.impetus.annovention.listener.ClassAnnotationObjectDiscoveryListener;
import com.impetus.annovention.listener.FieldAnnotationDiscoveryListener;
import com.impetus.annovention.listener.FieldAnnotationObjectDiscoveryListener;
import com.impetus.annovention.listener.MethodAnnotationDiscoveryListener;
import com.impetus.annovention.listener.MethodAnnotationObjectDiscoveryListener;
import com.impetus.annovention.listener.MethodParameterAnnotationDiscoveryListener;
import com.impetus.annovention.listener.MethodParameterAnnotationObjectDiscoveryListener;
import com.impetus.annovention.resource.ClassFileIterator;
import com.impetus.annovention.resource.JarFileIterator;
import com.impetus.annovention.resource.ResourceIterator;
import com.impetus.annovention.util.MethodParameter;
import com.impetus.annovention.util.MethodParameters;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Discoverer {
    private final Map<String, Set<ClassAnnotationDiscoveryListener>> classAnnotationListeners = new HashMap<String, Set<ClassAnnotationDiscoveryListener>>();
    private final Map<String, Set<FieldAnnotationDiscoveryListener>> fieldAnnotationListeners = new HashMap<String, Set<FieldAnnotationDiscoveryListener>>();
    private final Map<String, Set<MethodAnnotationDiscoveryListener>> methodAnnotationListeners = new HashMap<String, Set<MethodAnnotationDiscoveryListener>>();
    private final Map<String, Set<MethodParameterAnnotationDiscoveryListener>> methodParameterAnnotationListeners = new HashMap<String, Set<MethodParameterAnnotationDiscoveryListener>>();
    private static final Map<String, Set<ClassAnnotationObjectDiscoveryListener>> classAnnotationObjectListeners = new HashMap<String, Set<ClassAnnotationObjectDiscoveryListener>>();
    private static final Map<String, Set<FieldAnnotationObjectDiscoveryListener>> fieldAnnotationObjectListeners = new HashMap<String, Set<FieldAnnotationObjectDiscoveryListener>>();
    private static final Map<String, Set<MethodAnnotationObjectDiscoveryListener>> methodAnnotationObjectListeners = new HashMap<String, Set<MethodAnnotationObjectDiscoveryListener>>();
    private static final Map<String, Set<MethodParameterAnnotationObjectDiscoveryListener>> methodParameterAnnotationObjectListeners = new HashMap<String, Set<MethodParameterAnnotationObjectDiscoveryListener>>();

    public final void addAnnotationListener(ClassAnnotationDiscoveryListener classAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.classAnnotationListeners, classAnnotationDiscoveryListener, classAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(FieldAnnotationDiscoveryListener fieldAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.fieldAnnotationListeners, fieldAnnotationDiscoveryListener, fieldAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodAnnotationDiscoveryListener methodAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.methodAnnotationListeners, methodAnnotationDiscoveryListener, methodAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodParameterAnnotationDiscoveryListener methodParameterAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.methodParameterAnnotationListeners, methodParameterAnnotationDiscoveryListener, methodParameterAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(ClassAnnotationObjectDiscoveryListener classAnnotationObjectDiscoveryListener) {
        this.addAnnotationListener(classAnnotationObjectListeners, classAnnotationObjectDiscoveryListener, classAnnotationObjectDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(FieldAnnotationObjectDiscoveryListener fieldAnnotationObjectDiscoveryListener) {
        this.addAnnotationListener(fieldAnnotationObjectListeners, fieldAnnotationObjectDiscoveryListener, fieldAnnotationObjectDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodAnnotationObjectDiscoveryListener methodAnnotationObjectDiscoveryListener) {
        this.addAnnotationListener(methodAnnotationObjectListeners, methodAnnotationObjectDiscoveryListener, methodAnnotationObjectDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodParameterAnnotationObjectDiscoveryListener methodParameterAnnotationObjectDiscoveryListener) {
        this.addAnnotationListener(methodParameterAnnotationObjectListeners, methodParameterAnnotationObjectDiscoveryListener, methodParameterAnnotationObjectDiscoveryListener.supportedAnnotations());
    }

    private <L> void addAnnotationListener(Map<String, Set<L>> map, L l, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            throw new IllegalArgumentException(l.getClass() + " has no supporting Annotations. Check method supportedAnnotations");
        }
        for (String string : stringArray) {
            Set<L> set = map.get(string);
            if (null == set) {
                set = new HashSet<L>();
                map.put(string, set);
            }
            set.add(l);
        }
    }

    public abstract Filter getFilter();

    public abstract URL[] findResources();

    public final void discover(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.discover(bl, bl2, bl3, false, bl4, bl5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void discover(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        URL[] uRLArray;
        for (URL uRL : uRLArray = this.findResources()) {
            try {
                ResourceIterator resourceIterator = this.getResourceIterator(uRL, this.getFilter());
                if (resourceIterator == null) continue;
                InputStream inputStream = null;
                while ((inputStream = resourceIterator.next()) != null) {
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                    try {
                        ClassFile classFile = new ClassFile(dataInputStream);
                        if (bl) {
                            this.discoverAndIntimateForClassAnnotations(classFile, bl5, bl6);
                        }
                        if (bl2) {
                            this.discoverAndIntimateForFieldAnnotations(classFile, bl5, bl6);
                        }
                        if (!bl3 && !bl4) continue;
                        this.discoverAndIntimateForMethodAnnotations(classFile, bl3, bl4, bl5, bl6);
                    }
                    finally {
                        dataInputStream.close();
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void discoverAndIntimateForClassAnnotations(ClassFile classFile, boolean bl, boolean bl2) {
        Object object;
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        if (bl && (object = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations")) != null) {
            hashSet.addAll(Arrays.asList(object.getAnnotations()));
        }
        if (bl2 && (object = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            hashSet.addAll(Arrays.asList(object.getAnnotations()));
        }
        for (Annotation annotation : hashSet) {
            Object object2;
            Object object3;
            Set<ClassAnnotationDiscoveryListener> set = this.classAnnotationListeners.get(annotation.getTypeName());
            if (null != set) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (ClassAnnotationDiscoveryListener)object3.next();
                    object2.discovered(classFile.getName(), annotation.getTypeName());
                }
            }
            if (null == (object3 = classAnnotationObjectListeners.get(annotation.getTypeName()))) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                ClassAnnotationObjectDiscoveryListener classAnnotationObjectDiscoveryListener = (ClassAnnotationObjectDiscoveryListener)object2.next();
                classAnnotationObjectDiscoveryListener.discovered(classFile, annotation);
            }
        }
    }

    private void discoverAndIntimateForFieldAnnotations(ClassFile classFile, boolean bl, boolean bl2) {
        List list = classFile.getFields();
        if (list == null) {
            return;
        }
        for (FieldInfo fieldInfo : list) {
            Object object;
            HashSet<Annotation> hashSet = new HashSet<Annotation>();
            if (bl && (object = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            if (bl2 && (object = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3;
                Annotation annotation = (Annotation)object.next();
                Set<FieldAnnotationDiscoveryListener> set = this.fieldAnnotationListeners.get(annotation.getTypeName());
                if (null != set) {
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        object2 = (FieldAnnotationDiscoveryListener)object3.next();
                        object2.discovered(classFile.getName(), fieldInfo.getName(), annotation.getTypeName());
                    }
                }
                if (null == (object3 = fieldAnnotationObjectListeners.get(annotation.getTypeName()))) continue;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    FieldAnnotationObjectDiscoveryListener fieldAnnotationObjectDiscoveryListener = (FieldAnnotationObjectDiscoveryListener)object2.next();
                    fieldAnnotationObjectDiscoveryListener.discovered(classFile, fieldInfo, annotation);
                }
            }
        }
    }

    private void discoverAndIntimateForMethodAnnotations(ClassFile classFile, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List list = classFile.getMethods();
        if (list == null) {
            return;
        }
        for (MethodInfo methodInfo : list) {
            Set<MethodParameterAnnotationDiscoveryListener> set;
            Object object;
            Object object2;
            Collection<Object> collection;
            MethodParameter methodParameter;
            Object object3;
            Collection<Object> collection2;
            if (bl) {
                collection2 = new HashSet();
                if (bl3 && (object3 = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                    collection2.addAll(Arrays.asList(object3.getAnnotations()));
                }
                if (bl4 && (object3 = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                    collection2.addAll(Arrays.asList(object3.getAnnotations()));
                }
                object3 = collection2.iterator();
                while (object3.hasNext()) {
                    methodParameter = (Annotation)object3.next();
                    collection = this.methodAnnotationListeners.get(methodParameter.getTypeName());
                    if (null != collection) {
                        object2 = collection.iterator();
                        while (object2.hasNext()) {
                            object = (MethodAnnotationDiscoveryListener)object2.next();
                            object.discovered(classFile.getName(), methodInfo.getName(), methodParameter.getTypeName());
                        }
                    }
                    if (null == (object2 = methodAnnotationObjectListeners.get(methodParameter.getTypeName()))) continue;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        set = (MethodAnnotationObjectDiscoveryListener)object.next();
                        set.discovered(classFile, methodInfo, (Annotation)methodParameter);
                    }
                }
            }
            if (!bl2) continue;
            collection2 = MethodParameters.getMethodParameters(methodInfo, bl3, bl4);
            object3 = collection2.iterator();
            while (object3.hasNext()) {
                methodParameter = (MethodParameter)object3.next();
                collection = methodParameter.getAnnotations();
                if (collection == null || collection.size() <= 0) continue;
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    Object object4;
                    Object object5;
                    object = (Annotation)object2.next();
                    set = this.methodParameterAnnotationListeners.get(object.getTypeName());
                    if (null != set) {
                        object5 = set.iterator();
                        while (object5.hasNext()) {
                            object4 = (MethodParameterAnnotationDiscoveryListener)object5.next();
                            object4.discovered(classFile.getName(), methodInfo.getName(), methodParameter.getIndex(), methodParameter.getType(), object.getTypeName());
                        }
                    }
                    if (null == (object5 = methodParameterAnnotationObjectListeners.get(object.getTypeName()))) continue;
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        MethodParameterAnnotationObjectDiscoveryListener methodParameterAnnotationObjectDiscoveryListener = (MethodParameterAnnotationObjectDiscoveryListener)object4.next();
                        methodParameterAnnotationObjectDiscoveryListener.discovered(classFile, methodInfo, methodParameter, (Annotation)object);
                    }
                }
            }
        }
    }

    private ResourceIterator getResourceIterator(URL uRL, Filter filter) throws IOException {
        String string = uRL.toString();
        if (string.endsWith("!/")) {
            string = string.substring(4);
            string = string.substring(0, string.length() - 2);
            uRL = new URL(string);
        }
        if (!string.endsWith("/")) {
            return new JarFileIterator(uRL.openStream(), filter);
        }
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("Unable to understand protocol: " + uRL.getProtocol());
        }
        String string2 = URLDecoder.decode(uRL.getPath(), "UTF-8");
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return new ClassFileIterator(file, filter);
        }
        return new JarFileIterator(uRL.openStream(), filter);
    }
}

