/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention.resource;

import com.impetus.annovention.Filter;
import com.impetus.annovention.resource.ResourceIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class JarFileIterator
implements ResourceIterator {
    private JarInputStream jarInputStream;
    private JarEntry next;
    private Filter filter;
    private boolean start = true;
    private boolean closed = false;

    public JarFileIterator(File file, Filter filter) throws IOException {
        this(new FileInputStream(file), filter);
    }

    public JarFileIterator(InputStream inputStream, Filter filter) throws IOException {
        this.filter = filter;
        this.jarInputStream = new JarInputStream(inputStream);
    }

    private void setNext() {
        this.start = true;
        try {
            if (this.next != null) {
                this.jarInputStream.closeEntry();
            }
            this.next = null;
            do {
                this.next = this.jarInputStream.getNextJarEntry();
            } while (this.next != null && (this.next.isDirectory() || this.filter == null || !this.filter.accepts(this.next.getName())));
            if (this.next == null) {
                this.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("failed to browse jar", iOException);
        }
    }

    @Override
    public InputStream next() {
        if (this.closed || this.next == null && !this.start) {
            return null;
        }
        this.setNext();
        if (this.next == null) {
            return null;
        }
        return new JarInputStreamWrapper(this.jarInputStream);
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            this.jarInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class JarInputStreamWrapper
    extends InputStream {
        private InputStream is;

        public JarInputStreamWrapper(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.is.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.is.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int n) {
            this.is.mark(n);
        }

        @Override
        public void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }
    }
}

