/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention;

import com.impetus.annovention.Filter;
import com.impetus.annovention.listener.ClassAnnotationDiscoveryListener;
import com.impetus.annovention.listener.FieldAnnotationDiscoveryListener;
import com.impetus.annovention.listener.MethodAnnotationDiscoveryListener;
import com.impetus.annovention.resource.ClassFileIterator;
import com.impetus.annovention.resource.JarFileIterator;
import com.impetus.annovention.resource.ResourceIterator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

public abstract class Discoverer {
    private final Map<String, Set<ClassAnnotationDiscoveryListener>> classAnnotationListeners = new HashMap<String, Set<ClassAnnotationDiscoveryListener>>();
    private final Map<String, Set<FieldAnnotationDiscoveryListener>> fieldAnnotationListeners = new HashMap<String, Set<FieldAnnotationDiscoveryListener>>();
    private final Map<String, Set<MethodAnnotationDiscoveryListener>> methodAnnotationListeners = new HashMap<String, Set<MethodAnnotationDiscoveryListener>>();

    public final void addAnnotationListener(ClassAnnotationDiscoveryListener classAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.classAnnotationListeners, classAnnotationDiscoveryListener, classAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(FieldAnnotationDiscoveryListener fieldAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.fieldAnnotationListeners, fieldAnnotationDiscoveryListener, fieldAnnotationDiscoveryListener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodAnnotationDiscoveryListener methodAnnotationDiscoveryListener) {
        this.addAnnotationListener(this.methodAnnotationListeners, methodAnnotationDiscoveryListener, methodAnnotationDiscoveryListener.supportedAnnotations());
    }

    private <L> void addAnnotationListener(Map<String, Set<L>> map, L l, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            throw new IllegalArgumentException(l.getClass() + " has no supporting Annotations. Check method supportedAnnotations");
        }
        for (String string : stringArray) {
            Set<L> set = map.get(string);
            if (null == set) {
                set = new HashSet<L>();
                map.put(string, set);
            }
            set.add(l);
        }
    }

    public abstract Filter getFilter();

    public abstract URL[] findResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void discover(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        URL[] uRLArray;
        for (URL uRL : uRLArray = this.findResources()) {
            try {
                ResourceIterator resourceIterator = this.getResourceIterator(uRL, this.getFilter());
                if (resourceIterator == null) continue;
                InputStream inputStream = null;
                while ((inputStream = resourceIterator.next()) != null) {
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                    try {
                        ClassFile classFile = new ClassFile(dataInputStream);
                        if (bl) {
                            this.discoverAndIntimateForClassAnnotations(classFile, bl4, bl5);
                        }
                        if (bl2) {
                            this.discoverAndIntimateForFieldAnnotations(classFile, bl4, bl5);
                        }
                        if (!bl3) continue;
                        this.discoverAndIntimateForMethodAnnotations(classFile, bl4, bl5);
                    }
                    finally {
                        dataInputStream.close();
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void discoverAndIntimateForClassAnnotations(ClassFile classFile, boolean bl, boolean bl2) {
        Object object;
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        if (bl && (object = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations")) != null) {
            hashSet.addAll(Arrays.asList(object.getAnnotations()));
        }
        if (bl2 && (object = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            hashSet.addAll(Arrays.asList(object.getAnnotations()));
        }
        for (Annotation annotation : hashSet) {
            Set<ClassAnnotationDiscoveryListener> set = this.classAnnotationListeners.get(annotation.getTypeName());
            if (null == set) continue;
            for (ClassAnnotationDiscoveryListener classAnnotationDiscoveryListener : set) {
                classAnnotationDiscoveryListener.discovered(classFile.getName(), annotation.getTypeName());
            }
        }
    }

    private void discoverAndIntimateForFieldAnnotations(ClassFile classFile, boolean bl, boolean bl2) {
        List list = classFile.getFields();
        if (list == null) {
            return;
        }
        for (FieldInfo fieldInfo : list) {
            Object object;
            HashSet<Annotation> hashSet = new HashSet<Annotation>();
            if (bl && (object = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            if (bl2 && (object = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                Annotation annotation = (Annotation)object.next();
                Set<FieldAnnotationDiscoveryListener> set = this.fieldAnnotationListeners.get(annotation.getTypeName());
                if (null == set) continue;
                for (FieldAnnotationDiscoveryListener fieldAnnotationDiscoveryListener : set) {
                    fieldAnnotationDiscoveryListener.discovered(classFile.getName(), fieldInfo.getName(), annotation.getTypeName());
                }
            }
        }
    }

    private void discoverAndIntimateForMethodAnnotations(ClassFile classFile, boolean bl, boolean bl2) {
        List list = classFile.getMethods();
        if (list == null) {
            return;
        }
        for (MethodInfo methodInfo : list) {
            Object object;
            HashSet<Annotation> hashSet = new HashSet<Annotation>();
            if (bl && (object = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            if (bl2 && (object = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                hashSet.addAll(Arrays.asList(object.getAnnotations()));
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                Annotation annotation = (Annotation)object.next();
                Set<MethodAnnotationDiscoveryListener> set = this.methodAnnotationListeners.get(annotation.getTypeName());
                if (null == set) continue;
                for (MethodAnnotationDiscoveryListener methodAnnotationDiscoveryListener : set) {
                    methodAnnotationDiscoveryListener.discovered(classFile.getName(), methodInfo.getName(), annotation.getTypeName());
                }
            }
        }
    }

    private ResourceIterator getResourceIterator(URL uRL, Filter filter) throws IOException {
        String string = uRL.toString();
        if (string.endsWith("!/")) {
            string = string.substring(4);
            string = string.substring(0, string.length() - 2);
            uRL = new URL(string);
        }
        if (!string.endsWith("/")) {
            return new JarFileIterator(uRL.openStream(), filter);
        }
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("Unable to understand protocol: " + uRL.getProtocol());
        }
        String string2 = URLDecoder.decode(uRL.getPath(), "UTF-8");
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return new ClassFileIterator(file, filter);
        }
        return new JarFileIterator(uRL.openStream(), filter);
    }
}

