/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention;

import com.impetus.annovention.Discoverer;
import com.impetus.annovention.Filter;
import com.impetus.annovention.FilterImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ClasspathDiscoverer
extends Discoverer {
    private Filter filter = new FilterImpl();

    @Override
    public final URL[] findResources() {
        URL[] uRLArray = this.getUrlsForCurrentClasspath();
        if (uRLArray.length == 0) {
            uRLArray = this.getUrlsForSystemClasspath();
        }
        return uRLArray;
    }

    @Override
    public final Filter getFilter() {
        return this.filter;
    }

    public final void setFilter(Filter filter) {
        this.filter = filter;
    }

    private URL[] getUrlsForCurrentClasspath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            List<URL> list = Arrays.asList(uRLArray);
            arrayList.addAll(list);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private URL[] getUrlsForSystemClasspath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (!file.exists()) {
                throw new RuntimeException("File in java.class.path does not exist: " + file);
            }
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }
}

