/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention;

import com.impetus.annovention.Filter;
import com.impetus.annovention.listener.ClassAnnotationDiscoveryListener;
import com.impetus.annovention.listener.FieldAnnotationDiscoveryListener;
import com.impetus.annovention.listener.MethodAnnotationDiscoveryListener;
import com.impetus.annovention.resource.ClassFileIterator;
import com.impetus.annovention.resource.JarFileIterator;
import com.impetus.annovention.resource.ResourceIterator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Discoverer {
    private static final Map<String, Set<ClassAnnotationDiscoveryListener>> classAnnotationListeners = new HashMap<String, Set<ClassAnnotationDiscoveryListener>>();
    private static final Map<String, Set<FieldAnnotationDiscoveryListener>> fieldAnnotationListeners = new HashMap<String, Set<FieldAnnotationDiscoveryListener>>();
    private static final Map<String, Set<MethodAnnotationDiscoveryListener>> methodAnnotationListeners = new HashMap<String, Set<MethodAnnotationDiscoveryListener>>();

    public final void addAnnotationListener(ClassAnnotationDiscoveryListener listener) {
        this.addAnnotationListener(classAnnotationListeners, listener, listener.supportedAnnotations());
    }

    public final void addAnnotationListener(FieldAnnotationDiscoveryListener listener) {
        this.addAnnotationListener(fieldAnnotationListeners, listener, listener.supportedAnnotations());
    }

    public final void addAnnotationListener(MethodAnnotationDiscoveryListener listener) {
        this.addAnnotationListener(methodAnnotationListeners, listener, listener.supportedAnnotations());
    }

    private <L> void addAnnotationListener(Map<String, Set<L>> map, L listener, String ... annotations) {
        if (null == annotations || annotations.length == 0) {
            throw new IllegalArgumentException(listener.getClass() + " has no supporting Annotations. Check method supportedAnnotations");
        }
        for (String annotation : annotations) {
            Set<L> listeners = map.get(annotation);
            if (null == listeners) {
                listeners = new HashSet<L>();
                map.put(annotation, listeners);
            }
            listeners.add(listener);
        }
    }

    public abstract Filter getFilter();

    public abstract URL[] findResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void discover(boolean classes, boolean fields, boolean methods, boolean visible, boolean invisible) {
        URL[] resources;
        for (URL resource : resources = this.findResources()) {
            try {
                ResourceIterator itr = this.getResourceIterator(resource, this.getFilter());
                if (itr == null) continue;
                InputStream is = null;
                while ((is = itr.next()) != null) {
                    DataInputStream dstream = new DataInputStream(new BufferedInputStream(is));
                    try {
                        ClassFile classFile = new ClassFile(dstream);
                        if (classes) {
                            this.discoverAndIntimateForClassAnnotations(classFile, visible, invisible);
                        }
                        if (fields) {
                            this.discoverAndIntimateForFieldAnnotations(classFile, visible, invisible);
                        }
                        if (!methods) continue;
                        this.discoverAndIntimateForMethodAnnotations(classFile, visible, invisible);
                    }
                    finally {
                        dstream.close();
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void discoverAndIntimateForClassAnnotations(ClassFile classFile, boolean visible, boolean invisible) {
        AnnotationsAttribute invisibleA;
        AnnotationsAttribute visibleA;
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        if (visible && (visibleA = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations")) != null) {
            annotations.addAll(Arrays.asList(visibleA.getAnnotations()));
        }
        if (invisible && (invisibleA = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            annotations.addAll(Arrays.asList(invisibleA.getAnnotations()));
        }
        for (Annotation annotation : annotations) {
            Set<ClassAnnotationDiscoveryListener> listeners = classAnnotationListeners.get(annotation.getTypeName());
            if (null == listeners) continue;
            for (ClassAnnotationDiscoveryListener listener : listeners) {
                listener.discovered(classFile.getName(), annotation.getTypeName());
            }
        }
    }

    private void discoverAndIntimateForFieldAnnotations(ClassFile classFile, boolean visible, boolean invisible) {
        List fields = classFile.getFields();
        if (fields == null) {
            return;
        }
        for (FieldInfo fieldInfo : fields) {
            AnnotationsAttribute invisibleA;
            AnnotationsAttribute visibleA;
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            if (visible && (visibleA = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                annotations.addAll(Arrays.asList(visibleA.getAnnotations()));
            }
            if (invisible && (invisibleA = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                annotations.addAll(Arrays.asList(invisibleA.getAnnotations()));
            }
            for (Annotation annotation : annotations) {
                Set<FieldAnnotationDiscoveryListener> listeners = fieldAnnotationListeners.get(annotation.getTypeName());
                if (null == listeners) continue;
                for (FieldAnnotationDiscoveryListener listener : listeners) {
                    listener.discovered(classFile.getName(), fieldInfo.getName(), annotation.getTypeName());
                }
            }
        }
    }

    private void discoverAndIntimateForMethodAnnotations(ClassFile classFile, boolean visible, boolean invisible) {
        List methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        for (MethodInfo methodInfo : methods) {
            AnnotationsAttribute invisibleA;
            AnnotationsAttribute visibleA;
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            if (visible && (visibleA = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations")) != null) {
                annotations.addAll(Arrays.asList(visibleA.getAnnotations()));
            }
            if (invisible && (invisibleA = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations")) != null) {
                annotations.addAll(Arrays.asList(invisibleA.getAnnotations()));
            }
            for (Annotation annotation : annotations) {
                Set<MethodAnnotationDiscoveryListener> listeners = methodAnnotationListeners.get(annotation.getTypeName());
                if (null == listeners) continue;
                for (MethodAnnotationDiscoveryListener listener : listeners) {
                    listener.discovered(classFile.getName(), methodInfo.getName(), annotation.getTypeName());
                }
            }
        }
    }

    private ResourceIterator getResourceIterator(URL url, Filter filter) throws IOException {
        String urlString = url.toString();
        if (urlString.endsWith("!/")) {
            urlString = urlString.substring(4);
            urlString = urlString.substring(0, urlString.length() - 2);
            url = new URL(urlString);
        }
        if (!urlString.endsWith("/")) {
            return new JarFileIterator(url.openStream(), filter);
        }
        if (!url.getProtocol().equals("file")) {
            throw new IOException("Unable to understand protocol: " + url.getProtocol());
        }
        String filePath = URLDecoder.decode(url.getPath(), "UTF-8");
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return new ClassFileIterator(f, filter);
        }
        return new JarFileIterator(url.openStream(), filter);
    }
}

