/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.ratelimit;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.blademaker.slash.ratelimit.RateLimit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ltv/blademaker/slash/ratelimit/Bucket;", "", "annotation", "Ltv/blademaker/slash/ratelimit/RateLimit;", "(Ltv/blademaker/slash/ratelimit/RateLimit;)V", "remaining", "Ljava/util/concurrent/atomic/AtomicInteger;", "resetAfter", "", "(Ljava/util/concurrent/atomic/AtomicInteger;J)V", "getRemaining", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getResetAfter", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Slash"})
public final class Bucket {
    @NotNull
    private final AtomicInteger remaining;
    private final long resetAfter;

    public Bucket(@NotNull AtomicInteger remaining, long resetAfter) {
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        this.remaining = remaining;
        this.resetAfter = resetAfter;
    }

    @NotNull
    public final AtomicInteger getRemaining() {
        return this.remaining;
    }

    public final long getResetAfter() {
        return this.resetAfter;
    }

    public Bucket(@NotNull RateLimit annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        this(new AtomicInteger(annotation.quota() - 1), System.currentTimeMillis() + annotation.unit().toMillis(annotation.duration()));
    }

    @NotNull
    public final AtomicInteger component1() {
        return this.remaining;
    }

    public final long component2() {
        return this.resetAfter;
    }

    @NotNull
    public final Bucket copy(@NotNull AtomicInteger remaining, long resetAfter) {
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        return new Bucket(remaining, resetAfter);
    }

    public static /* synthetic */ Bucket copy$default(Bucket bucket, AtomicInteger atomicInteger, long l, int n, Object object) {
        if ((n & 1) != 0) {
            atomicInteger = bucket.remaining;
        }
        if ((n & 2) != 0) {
            l = bucket.resetAfter;
        }
        return bucket.copy(atomicInteger, l);
    }

    @NotNull
    public String toString() {
        return "Bucket(remaining=" + this.remaining + ", resetAfter=" + this.resetAfter + ")";
    }

    public int hashCode() {
        int result = this.remaining.hashCode();
        result = result * 31 + Long.hashCode(this.resetAfter);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bucket)) {
            return false;
        }
        Bucket bucket = (Bucket)other;
        if (!Intrinsics.areEqual((Object)this.remaining, (Object)bucket.remaining)) {
            return false;
        }
        return this.resetAfter == bucket.resetAfter;
    }
}

