/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.exceptions;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.TimeoutCancellationException;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.requests.FluentRestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.slash.BaseSlashCommand;
import tv.blademaker.slash.PermissionTarget;
import tv.blademaker.slash.SlashUtils;
import tv.blademaker.slash.annotations.InteractionTarget;
import tv.blademaker.slash.exceptions.ExceptionHandler;
import tv.blademaker.slash.exceptions.InteractionTargetMismatch;
import tv.blademaker.slash.exceptions.PermissionsLackException;
import tv.blademaker.slash.extensions.InteractionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0014H\u0016J-\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Ltv/blademaker/slash/exceptions/ExceptionHandlerImpl;", "Ltv/blademaker/slash/exceptions/ExceptionHandler;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onException", "", "ex", "", "command", "Ltv/blademaker/slash/BaseSlashCommand;", "event", "Lnet/dv8tion/jda/api/events/interaction/ModalInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/command/CommandAutoCompleteInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/component/ButtonInteractionEvent;", "onInteractionTargetMismatch", "Ltv/blademaker/slash/exceptions/InteractionTargetMismatch;", "onPermissionLackException", "Ltv/blademaker/slash/exceptions/PermissionsLackException;", "onTimeoutCancellationException", "Lkotlinx/coroutines/TimeoutCancellationException;", "timeout", "Lkotlin/time/Duration;", "onTimeoutCancellationException-SxA4cEA", "(Lkotlinx/coroutines/TimeoutCancellationException;Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;J)V", "Slash"})
public final class ExceptionHandlerImpl
implements ExceptionHandler {
    private final Logger log = LoggerFactory.getLogger((String)"ExceptionHandler");

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull ModalInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for modal `" + event.getModalId() + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, ex);
        if (event.isAcknowledged()) {
            event.getHook().sendMessage(message).setEphemeral(true).queue();
        } else {
            event.reply(message).setEphemeral(true).queue();
        }
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for slash command `" + InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event) + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, ex);
        if (event.isAcknowledged()) {
            event.getHook().sendMessage(message).setEphemeral(true).queue();
        } else {
            event.reply(message).setEphemeral(true).queue();
        }
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for auto-complete interaction `" + InteractionsKt.getCommandPath(event) + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, ex);
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull ButtonInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for button interaction `" + event.getButton().getId() + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, ex);
    }

    @Override
    public void onPermissionLackException(@NotNull PermissionsLackException ex) {
        ReplyCallbackAction replyCallbackAction;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$0[ex.getTarget().ordinal()]) {
            case 1: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("Bot doesn't have the required permissions to execute '" + ((SlashCommandInteractionEvent)ex.getContext().getEvent()).getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab The bot does not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            case 2: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("User " + ex.getContext().getUser() + " doesn't have the required permissions to execute '" + ((SlashCommandInteractionEvent)ex.getContext().getEvent()).getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab You do not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        replyCallbackAction.setEphemeral(true).queue();
    }

    @Override
    public void onInteractionTargetMismatch(@NotNull InteractionTargetMismatch ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$1[ex.getTarget().ordinal()]) {
            case 1: {
                ex.getContext().replyMessage("This command cannot be used outside of a **Guild**.").queue();
                break;
            }
            case 2: {
                ex.getContext().replyMessage("This command cannot be used on a **Guild**.").queue();
                break;
            }
            default: {
                throw new IllegalStateException("Received InteractionTargetMismatch on a command with target InteractionTarget.ALL, report this to developer.");
            }
        }
    }

    @Override
    public void onTimeoutCancellationException-SxA4cEA(@NotNull TimeoutCancellationException ex, @NotNull SlashCommandInteractionEvent event, long timeout) {
        WebhookMessageCreateAction webhookMessageCreateAction;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "\ud83d\udeab It has not been possible to complete the execution of the command in the estimated time of " + Duration.getInWholeSeconds-impl((long)timeout) + " seconds.";
        boolean bl = event.isAcknowledged();
        if (bl) {
            webhookMessageCreateAction = event.getHook().sendMessage(message).setEphemeral(true);
        } else if (!bl) {
            webhookMessageCreateAction = event.reply(message).setEphemeral(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ((FluentRestAction)webhookMessageCreateAction).queue();
    }

    @Override
    public void wrap(@NotNull Throwable e, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Override
    public void wrap(@NotNull Throwable e, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PermissionTarget.values().length];
            try {
                nArray[PermissionTarget.BOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionTarget.USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InteractionTarget.values().length];
            try {
                nArray[InteractionTarget.GUILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionTarget.DM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

