/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.derby;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.derby.jdbc.EmbeddedXADataSource;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.NoExceptionsAreFatalSorter;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AbstractXADataSourceMCF;
import org.tranql.connector.jdbc.ManagedXAConnection;

public class EmbeddedXAMCF
extends AbstractXADataSourceMCF {
    private final EmbeddedXADataSource ds;

    public EmbeddedXAMCF() {
        super((XADataSource)new EmbeddedXADataSource(), (ExceptionSorter)new NoExceptionsAreFatalSorter());
        this.ds = (EmbeddedXADataSource)this.xaDataSource;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)this);
        XAConnection sqlConnection = this.getPhysicalConnection(subject, credentialExtractor);
        try {
            return new ManagedXAConnection((ManagedConnectionFactory)this, sqlConnection, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
        }
    }

    public String getUserName() {
        return this.ds.getUser();
    }

    public void setUserName(String user) {
        this.ds.setUser(user);
    }

    public String getPassword() {
        return this.ds.getPassword();
    }

    public void setPassword(String password) {
        this.ds.setPassword(password);
    }

    public String getDatabaseName() {
        return this.ds.getDatabaseName();
    }

    public void setDatabaseName(String name) {
        this.ds.setDatabaseName(name);
    }

    public Boolean getCreateDatabase() {
        return "create".equals(this.ds.getCreateDatabase());
    }

    public void setCreateDatabase(Boolean create) {
        this.ds.setCreateDatabase(create != false ? "create" : null);
    }

    public void setShutdownDatabase(String shutDown) {
        this.ds.setShutdownDatabase(shutDown);
    }

    public String getShutdownDatabase() {
        return this.ds.getShutdownDatabase();
    }
}

