/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.derby;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.NoExceptionsAreFatalSorter;
import org.tranql.connector.jdbc.AbstractLocalDataSourceMCF;

public class ClientLocalMCF
extends AbstractLocalDataSourceMCF {
    private final ClientDataSource ds;

    public ClientLocalMCF() {
        super((DataSource)new ClientDataSource(), (ExceptionSorter)new NoExceptionsAreFatalSorter(), false);
        this.ds = (ClientDataSource)this.dataSource;
    }

    public String getUserName() {
        return this.ds.getUser();
    }

    public void setUserName(String user) {
        this.ds.setUser(user);
    }

    public String getPassword() {
        try {
            return ClientBaseDataSource.getPassword((Properties)this.ds.getProperties());
        }
        catch (SQLException e) {
            throw new AssertionError();
        }
    }

    public void setPassword(String password) {
        this.ds.setPassword(password);
    }

    public String getServerName() {
        return this.ds.getServerName();
    }

    public void setServerName(String serverName) {
        this.ds.setServerName(serverName);
    }

    public Integer getPortNumber() {
        return new Integer(this.ds.getPortNumber());
    }

    public void setPortNumber(Integer port) {
        this.ds.setPortNumber(port.intValue());
    }

    public String getDatabaseName() {
        return this.ds.getDatabaseName();
    }

    public void setDatabaseName(String name) {
        this.ds.setDatabaseName(name);
    }

    public Boolean getCreateDatabase() {
        try {
            return this.ds.getProperties().containsKey("create");
        }
        catch (SQLException e) {
            throw new AssertionError();
        }
    }

    public void setCreateDatabase(Boolean create) {
        try {
            Properties props = this.ds.getProperties();
            if (create.booleanValue()) {
                props.setProperty("create", "create");
            } else {
                props.remove("create");
            }
        }
        catch (SQLException e) {
            throw new AssertionError();
        }
    }

    public Boolean getRetrieveMessageText() {
        return this.ds.getRetrieveMessageText();
    }

    public void setRetrieveMessageText(Boolean b) {
        this.ds.setRetrieveMessageText(b.booleanValue());
    }
}

