/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xsl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ApplyTag
extends BodyTagSupport {
    private String body = null;
    private String nameXml = null;
    private String nameXsl = null;
    private String propertyXml = null;
    private String propertyXsl = null;
    private String xml = null;
    private String xsl = null;

    public String getNameXml() {
        return this.nameXml;
    }

    public void setNameXml(String nameXml) {
        this.nameXml = nameXml;
    }

    public String getNameXsl() {
        return this.nameXsl;
    }

    public void setNameXsl(String nameXsl) {
        this.nameXsl = nameXsl;
    }

    public String getPropertyXml() {
        return this.propertyXml;
    }

    public void setPropertyXml(String propertyXml) {
        this.propertyXml = propertyXml;
    }

    public String getPropertyXsl() {
        return this.propertyXsl;
    }

    public void setPropertyXsl(String propertyXsl) {
        this.propertyXsl = propertyXsl;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getXsl() {
        return this.xsl;
    }

    public void setXsl(String xsl) {
        this.xsl = xsl;
    }

    public int doStartTag() throws JspException {
        if (this.nameXml != null) {
            if (this.xml != null) {
                throw new JspException("Cannot specify both 'nameXml' and 'xml'");
            }
        } else if (this.propertyXml != null) {
            throw new JspException("Cannot specify 'propertyXml' without 'nameXml'");
        }
        if (this.nameXsl != null) {
            if (this.xsl != null) {
                throw new JspException("Cannot specify both 'nameXsl' and 'xsl'");
            }
        } else if (this.propertyXsl != null) {
            throw new JspException("Cannot specify 'propertyXsl' without 'nameXsl'");
        }
        if (this.nameXsl == null && this.xsl == null) {
            throw new JspException("Must specify either 'nameXsl' or 'xsl'");
        }
        if (this.nameXml == null && this.xml == null) {
            return 2;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        this.body = this.bodyContent == null ? "" : this.bodyContent.getString().trim();
        return 0;
    }

    public int doEndTag() throws JspException {
        XSLTInputSource data = null;
        data = this.body != null ? new XSLTInputSource((Reader)new StringReader(this.body)) : this.getInputSource(this.nameXml, this.propertyXml, this.xml);
        XSLTInputSource style = this.getInputSource(this.nameXsl, this.propertyXsl, this.xsl);
        XSLTResultTarget result = new XSLTResultTarget((Writer)((TagSupport)this).pageContext.getOut());
        XSLTProcessor processor = null;
        try {
            processor = XSLTProcessorFactory.getProcessor();
            processor.process(data, style, result);
        }
        catch (SAXException e) {
            throw new JspException(e.toString());
        }
        return 6;
    }

    public void release() {
        this.body = null;
    }

    private XSLTInputSource getInputSource(String name, String property, String resource) throws JspException {
        if (resource != null) {
            ServletContext context = ((TagSupport)this).pageContext.getServletContext();
            if (context == null) {
                throw new JspException("Cannot find servlet context");
            }
            InputStream stream = context.getResourceAsStream(resource);
            if (stream == null) {
                throw new JspException("Missing resource '" + resource + "'");
            }
            return new XSLTInputSource(stream);
        }
        Object source = null;
        Object bean = ((TagSupport)this).pageContext.findAttribute(name);
        if (bean == null) {
            throw new JspException("Missing bean '" + name + "'");
        }
        if (property == null) {
            source = bean;
        } else {
            try {
                char first = Character.toUpperCase(property.charAt(0));
                String methodName = "get" + first + property.substring(1);
                Class[] paramTypes = new Class[]{};
                Method method = bean.getClass().getMethod(methodName, paramTypes);
                source = method.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new JspException(e.toString());
            }
        }
        if (source instanceof XSLTInputSource) {
            return (XSLTInputSource)source;
        }
        if (source instanceof String) {
            return new XSLTInputSource((Reader)new StringReader((String)source));
        }
        if (source instanceof InputSource) {
            return new XSLTInputSource((InputSource)source);
        }
        if (source instanceof InputStream) {
            return new XSLTInputSource((InputStream)source);
        }
        if (source instanceof Node) {
            return new XSLTInputSource((Node)source);
        }
        if (source instanceof Reader) {
            return new XSLTInputSource((Reader)source);
        }
        throw new JspException("Invalid input source type '" + source.getClass().getName() + "'");
    }
}

