package org.apache.taglibs.jsp12;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;

import java.io.IOException;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.servlet.jsp.tagext.TagSupport;

/**
 * Custom tag that allows JSP 1.1 users to emulate the
 * behaviour of the JSP 1.2 version of the jsp:getProperty
 * tag.
 */

public class GetPropertyTag extends TagSupport{
  
  String _name     = null;
  String _property = null;
  
  public void setName(String name) {
    _name = name;
  }
  
  public void setProperty(String property) {
    _property = property;
  }
  
  public int doStartTag() {
    Object o = pageContext.getAttribute(_name);
    
    if (o == null) {
      return EVAL_BODY_INCLUDE;
    }
    
    // perform introspection to access getter method
    Class cls = o.getClass();
    BeanInfo beanInfo;
    try {
      beanInfo = Introspector.getBeanInfo(cls);
    } catch (IntrospectionException e) {
      e.printStackTrace();
      return EVAL_BODY_INCLUDE;
    }
    
    PropertyDescriptor descriptors[] = beanInfo.getPropertyDescriptors();
    Method getterMethod = null;
    for (int i = 0; i < descriptors.length; ++i) {
      if (descriptors[i].getName().equals(_property)) {
        getterMethod = descriptors[i].getReadMethod();
      }
    }
    
    if (getterMethod != null) {    
      try {
        pageContext.getOut().print(getterMethod.invoke(o, new Object[0]));
      } catch (IllegalAccessException e) {
        e.printStackTrace();
      } catch (InvocationTargetException e) {
        e.printStackTrace();
      } catch (IOException e) { 
        e.printStackTrace();
      }
    }
    return EVAL_BODY_INCLUDE;
  }
  
  public void release() {
    _name = null;
    _property = null;
  }
}