/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Length;
import javax.measure.spi.ServiceProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import systems.uom.unicode.CLDR;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.Units;

public class UnitFormatTest {
    private Quantity<Length> sut;
    private SimpleUnitFormat format2;

    @BeforeEach
    public void init() {
        this.sut = ServiceProvider.current().getQuantityFactory(Length.class).create((Number)10, Units.METRE);
        this.format2 = SimpleUnitFormat.getInstance();
        this.format2.label(CLDR.CARAT, "ct");
        this.format2.label(CLDR.ACRE, "ac");
        this.format2.label(CLDR.TONNE, "t");
    }

    @Test
    public void testFormat2() {
        Unit kph = Units.KILOMETRE_PER_HOUR;
        Assertions.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat4() {
        Unit kph = Units.KILOMETRE_PER_HOUR;
        Assertions.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat6() {
        Unit b = CLDR.ACRE;
        Assertions.assertEquals((Object)"ac", (Object)b.toString());
    }

    @Test
    public void testParseSimple() {
        try {
            Unit u = this.format2.parse((CharSequence)"s");
            Assertions.assertEquals((Object)"s", (Object)u.getSymbol());
            Assertions.assertEquals((Object)Units.SECOND, (Object)u);
        }
        catch (MeasurementParseException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFormatFromQuantity() {
        StringBuilder a = new StringBuilder();
        try {
            this.format2.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
        Assertions.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assertions.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = this.sut.getUnit().divide(Units.SECOND);
        try {
            this.format2.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
        Assertions.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testParseSimple1() {
        try {
            Unit u = this.format2.parse((CharSequence)"min");
            Assertions.assertEquals((Object)Units.MINUTE, (Object)u);
        }
        catch (MeasurementParseException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple2() {
        try {
            Unit u = this.format2.parse((CharSequence)"m");
            Assertions.assertEquals((Object)"m", (Object)u.getSymbol());
            Assertions.assertEquals((Object)Units.METRE, (Object)u);
        }
        catch (MeasurementParseException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple3() {
        try {
            Unit u = this.format2.parse((CharSequence)"kg");
            Assertions.assertEquals((Object)"kg", (Object)u.getSymbol());
            Assertions.assertEquals((Object)Units.KILOGRAM, (Object)u);
        }
        catch (MeasurementParseException e) {
            Assertions.fail((String)e.getMessage());
        }
    }
}

