/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.util.List;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SystemOfUnitsServiceTest {
    private static final int NUM_OF_UNITS_CLDR = 110;
    private static SystemOfUnitsService defaultService;

    @BeforeAll
    public static void setUp() {
        defaultService = ServiceProvider.current().getSystemOfUnitsService();
    }

    @Test
    public void testDefaultUnitSystemService() {
        Assertions.assertNotNull((Object)defaultService);
        Assertions.assertEquals((Object)"systems.uom.unicode.spi.CLDRSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits();
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.unicode.CLDR", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"Unicode CLDR", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)110, (int)system.getUnits().size());
    }

    @Test
    public void testCLDRUnitSystemService() {
        ServiceProvider cldrProvider = ServiceProvider.of((String)"Unicode");
        Assertions.assertNotNull((Object)cldrProvider);
        SystemOfUnitsService cldrService = cldrProvider.getSystemOfUnitsService();
        Assertions.assertNotNull((Object)cldrService);
        Assertions.assertEquals((Object)"systems.uom.unicode.spi.CLDRSystemService", (Object)cldrService.getClass().getName());
        SystemOfUnits system = cldrService.getSystemOfUnits();
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.unicode.CLDR", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"Unicode CLDR", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)110, (int)system.getUnits().size());
    }

    @Test
    public void testOtherUnitSystemServices() {
        List services = ServiceProvider.available();
        Assertions.assertNotNull((Object)services);
        Assertions.assertEquals((int)2, (int)services.size());
    }

    @Test
    public void testUnitSystemServiceAlias() {
        ServiceProvider cldrProvider = ServiceProvider.of((String)"Unicode");
        Assertions.assertNotNull((Object)cldrProvider);
        SystemOfUnitsService cldrService = cldrProvider.getSystemOfUnitsService();
        Assertions.assertNotNull((Object)cldrService);
        Assertions.assertEquals((Object)"systems.uom.unicode.spi.CLDRSystemService", (Object)cldrService.getClass().getName());
        SystemOfUnits system = cldrService.getSystemOfUnits("CLDR");
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.unicode.CLDR", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"Unicode CLDR", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)110, (int)system.getUnits().size());
        SystemOfUnits system2 = cldrService.getSystemOfUnits("Unicode");
        Assertions.assertEquals((Object)system, (Object)system2);
    }
}

