/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.math.BigDecimal;
import javax.measure.BinaryPrefix;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import systems.uom.unicode.CLDR;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.Units;

public class CLDRTest {
    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"kg", (Object)Units.KILOGRAM.toString());
        Assertions.assertEquals((Object)"ct", (Object)CLDR.CARAT.toString());
        Assertions.assertEquals((Object)"in-hg", (Object)CLDR.INCH_HG.toString());
        Assertions.assertEquals((Object)"dct", (Object)MetricPrefix.DECI((Unit)CLDR.CARAT).toString());
        Assertions.assertEquals((Object)"st", (Object)CLDR.STONE.toString());
        Assertions.assertEquals((Object)"Kist", (Object)BinaryPrefix.KIBI((Unit)CLDR.STONE).toString());
    }

    @Test
    public void testGetSymbol() {
        Assertions.assertEquals((Object)"kg", (Object)Units.KILOGRAM.getSymbol());
        Assertions.assertNull((Object)MetricPrefix.KILO((Unit)CLDR.GRAM).getSymbol());
        Assertions.assertNull((Object)CLDR.GRAM.getSymbol());
    }

    @Test
    public void testConvert() {
        ComparableQuantity kph = Quantities.getQuantity((Number)30, (Unit)Units.KILOMETRE_PER_HOUR);
        Quantity knots = kph.to(CLDR.KNOT);
        Assertions.assertEquals((Object)RationalNumber.of((BigDecimal)new BigDecimal("16.19870410367170626349892008639309")), (Object)knots.getValue());
    }

    @Test
    public void testParse() {
        Assertions.assertEquals((Object)Units.KILOGRAM, (Object)AbstractUnit.parse((CharSequence)"kg"));
        Assertions.assertEquals((Object)CLDR.CARAT, (Object)AbstractUnit.parse((CharSequence)"ct"));
        Assertions.assertEquals((Object)MetricPrefix.DECI((Unit)Units.METRE), (Object)AbstractUnit.parse((CharSequence)"dm"));
    }
}

