/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.unicode.CLDR;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.quantity.DefaultQuantityFactory;
import tec.units.ri.unit.Units;

public class UnitFormatTest {
    private Quantity<Length> sut;
    private SimpleUnitFormat format2;

    @Before
    public void init() {
        this.sut = DefaultQuantityFactory.getInstance(Length.class).create((Number)10, Units.METRE);
        this.format2 = SimpleUnitFormat.getInstance();
        this.format2.label(CLDR.CARAT, "ct");
        this.format2.label(CLDR.HECTARE, "Ha");
        this.format2.label(CLDR.TONNE, "t");
    }

    @Test
    public void testFormat2() {
        Unit kph = Units.KILOMETRES_PER_HOUR;
        Assert.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat4() {
        Unit kph = Units.KILOMETRES_PER_HOUR;
        Assert.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat6() {
        Unit b = CLDR.HECTARE;
        Assert.assertEquals((Object)"Ha", (Object)b.toString());
    }

    @Test
    public void testParseSimple() {
        try {
            Unit u = this.format2.parse((CharSequence)"s");
            Assert.assertEquals((Object)"s", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.SECOND, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFormatFromQuantity() {
        StringBuilder a = new StringBuilder();
        try {
            this.format2.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = this.sut.getUnit().divide(Units.SECOND);
        try {
            this.format2.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testParseSimple1() {
        try {
            Unit u = this.format2.parse((CharSequence)"min");
            Assert.assertEquals((Object)Units.MINUTE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple2() {
        try {
            Unit u = this.format2.parse((CharSequence)"m");
            Assert.assertEquals((Object)"m", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.METRE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple3() {
        try {
            Unit u = this.format2.parse((CharSequence)"kg");
            Assert.assertEquals((Object)"kg", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.KILOGRAM, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

