/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.unicode.CLDR;
import tec.uom.se.format.EBNFUnitFormat;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.quantity.DefaultQuantityFactory;
import tec.uom.se.unit.Units;

public class UnitFormatTest {
    private Quantity<Length> sut;
    private EBNFUnitFormat format;
    private SimpleUnitFormat format2;

    @Before
    public void init() {
        this.sut = DefaultQuantityFactory.getInstance(Length.class).create((Number)10, Units.METRE);
        this.format = EBNFUnitFormat.getInstance();
        this.format2 = SimpleUnitFormat.getInstance();
        this.format2.label(CLDR.CARAT, "ct");
        this.format2.label(CLDR.HECTARE, "Ha");
        this.format2.label(CLDR.TONNE, "t");
    }

    @Test
    public void testFormat2() {
        Unit kph = Units.KILOMETRES_PER_HOUR;
        Assert.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat4() {
        Unit kph = Units.KILOMETRES_PER_HOUR;
        Assert.assertEquals((Object)"km/h", (Object)kph.toString());
    }

    @Test
    public void testFormat6() {
        Unit b = CLDR.HECTARE;
        Assert.assertEquals((Object)"Ha", (Object)b.toString());
    }

    @Test
    public void testFormat7() {
        Unit c = CLDR.CARAT;
        Assert.assertEquals((Object)"ct", (Object)c.toString());
    }

    @Test
    public void testParseSimple() {
        EBNFUnitFormat format = EBNFUnitFormat.getInstance();
        try {
            Unit u = format.parse((CharSequence)"s");
            Assert.assertEquals((Object)"s", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.SECOND, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFormatFromQuantity() {
        EBNFUnitFormat format = EBNFUnitFormat.getInstance();
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = this.sut.getUnit().divide(Units.SECOND);
        try {
            format.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testParseSimple1() {
        EBNFUnitFormat format = EBNFUnitFormat.getInstance();
        try {
            Unit u = format.parse((CharSequence)"min");
            Assert.assertEquals((Object)Units.MINUTE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple2() {
        EBNFUnitFormat format = EBNFUnitFormat.getInstance();
        try {
            Unit u = format.parse((CharSequence)"m");
            Assert.assertEquals((Object)"m", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.METRE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSimple3() {
        EBNFUnitFormat format = EBNFUnitFormat.getInstance();
        try {
            Unit u = format.parse((CharSequence)"kg");
            Assert.assertEquals((Object)"kg", (Object)u.getSymbol());
            Assert.assertEquals((Object)Units.KILOGRAM, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

