/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.unicode.CLDR;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class CLDRTest {
    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"kg", (Object)Units.KILOGRAM.toString());
        Assert.assertEquals((Object)"ct", (Object)CLDR.CARAT.toString());
    }

    @Test
    public void testGetSymbol() {
        Assert.assertEquals((Object)"kg", (Object)Units.KILOGRAM.getSymbol());
        Assert.assertEquals((Object)"kg", (Object)MetricPrefix.KILO((Unit)CLDR.GRAM).getSymbol());
        Assert.assertEquals((Object)"g", (Object)CLDR.GRAM.toString());
    }

    @Test
    public void testConvert() {
        ComparableQuantity kph = Quantities.getQuantity((Number)30, (Unit)Units.KILOMETRES_PER_HOUR);
        Quantity knots = kph.to(CLDR.KNOT);
        Assert.assertEquals((Object)16.19871706263499, (Object)knots.getValue());
    }
}

