/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import systems.uom.ucum.UCUM;
import tec.uom.lib.common.function.IntPrioritySupplier;

final class UCUMSystemService
implements SystemOfUnitsService,
IntPrioritySupplier {
    static final int PRIO = 100;
    private static final String DEFAULT_SYSTEM_NAME = "UCUM";
    private final Map<String, SystemOfUnits> souMap = new HashMap<String, SystemOfUnits>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    UCUMSystemService() {
        this.souMap.put(DEFAULT_SYSTEM_NAME, (SystemOfUnits)UCUM.getInstance());
        this.aliases.put("Unified Code for Units of Measure", DEFAULT_SYSTEM_NAME);
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return this.souMap.values();
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.getSystemOfUnits(DEFAULT_SYSTEM_NAME);
    }

    public SystemOfUnits getSystemOfUnits(String name) {
        String alias = this.aliases.get(name);
        if (alias != null && alias.length() > 0) {
            return this.souMap.get(alias);
        }
        return this.souMap.get(name);
    }

    public int getPriority() {
        return 100;
    }
}

