/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.util.logging.Level;
import javax.measure.MeasurementException;
import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.StringUtils;
import systems.uom.ucum.format.UCUMFormatTestBase;

public class UnitFormatTest
extends UCUMFormatTestBase {
    @Test
    public void testUnitsUCUMpureASCII() {
        for (Unit u : UCUM.getInstance().getUnits()) {
            Assert.assertTrue((String)String.format("CS format %s contains non-ASCII characters", FORMAT_CS.format(u)), (boolean)StringUtils.isPureAscii(FORMAT_CS.format(u)));
            Assert.assertTrue((String)String.format("CI format %s contains non-ASCII characters", FORMAT_CI.format(u)), (boolean)StringUtils.isPureAscii(FORMAT_CI.format(u)));
        }
    }

    @Test
    public void testUnitsUCUM() {
        for (Unit u : UCUM.getInstance().getUnits()) {
            LOGGER.log(LOG_LEVEL, String.format("%s @ %s @ %s @ %s", FORMAT_CS.format(u), FORMAT_CI.format(u), FORMAT_PRINT.format(u), u));
        }
    }

    @Test
    public void testInvertUCUM() {
        for (Unit u : UCUM.getInstance().getUnits()) {
            try {
                Unit v = FORMAT_CS.parse((CharSequence)("1/" + FORMAT_CS.format(u)));
                LOGGER.log(LOG_LEVEL, String.format("%s @ %s @ %s @ %s -> %s @ %s", FORMAT_CI.format(u), FORMAT_CI.format(u), FORMAT_PRINT.format(u), u, FORMAT_PRINT.format(v), v));
            }
            catch (MeasurementException mex) {
                LOGGER.log(Level.WARNING, String.format(" %s parsing %s", new Object[]{mex, u}));
            }
        }
    }
}

