/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormatTestBase;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.MetricPrefix;

public class PrefixTest
extends UCUMFormatTestBase {
    @Test
    public void testKilo() {
        Unit m1 = MetricPrefix.KILO((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"kg", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testMega() {
        Unit m1 = MetricPrefix.MEGA((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"Mg", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testMega2() {
        Unit m1 = MetricPrefix.MEGA((Unit)UCUM.TONNE);
        Assert.assertEquals((Object)"Mt", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testNano() {
        Unit m1 = MetricPrefix.NANO((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"ng", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testBetweenPrefixes() {
        UnitConverter conv = MetricPrefix.YOTTA((Unit)UCUM.METER).getConverterTo(MetricPrefix.ZETTA((Unit)UCUM.METER));
        Assert.assertEquals((Object)conv, (Object)RationalConverter.of((long)1000L, (long)1L));
    }

    @Test
    public void testBetweenPrefixes2() {
        UnitConverter conv = MetricPrefix.KILO((Unit)UCUM.METER).getConverterTo(MetricPrefix.GIGA((Unit)UCUM.METER));
        Assert.assertEquals((Object)RationalConverter.of((double)1.0, (double)1000000.0), (Object)conv);
    }
}

