/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.Set;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Time;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.KinematicViscosity;
import tec.units.indriya.AbstractSystemOfUnits;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.format.SimpleUnitFormat;
import tec.units.indriya.unit.MetricPrefix;
import tec.units.indriya.unit.ProductUnit;
import tec.units.indriya.unit.Units;

public final class CGS
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Centimetre\u2013gram\u2013second System of Units";
    static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final CGS INSTANCE = new CGS();
    public static final Unit<Length> CENTIMETRE = CGS.addUnit(MetricPrefix.CENTI((Unit)Units.METRE));
    public static final Unit<Mass> GRAM = CGS.addUnit(Units.GRAM);
    public static final Unit<Time> SECOND = CGS.addUnit(Units.SECOND);
    public static final Unit<Speed> CENTIMETRE_PER_SECOND = CGS.addUnit(CENTIMETRE.divide(SECOND).asType(Speed.class), "centimetre per second", "cm/s");
    public static final Unit<Acceleration> GAL = CGS.addUnit(new ProductUnit(CENTIMETRE_PER_SECOND.divide(SECOND)).asType(Acceleration.class), "Gal", "Gal");
    public static final Unit<Energy> ERG = CGS.addUnit(Units.JOULE.divide(1.0E7), "Erg", "erg");
    public static final Unit<Force> DYNE = CGS.addUnit(Units.NEWTON.divide(100000.0), "Dyne", "dyn");
    public static final Unit<Power> ERG_PER_SECOND = CGS.addUnit(ERG.divide(SECOND).asType(Power.class), "Erg per second", "erg/s");
    public static final Unit<Pressure> BARYE = CGS.addUnit(Units.PASCAL.divide(10.0), "Barye", "Ba");
    public static final Unit<DynamicViscosity> POISE = CGS.addUnit(GRAM.divide(MetricPrefix.CENTI((Unit)Units.METRE).multiply(SECOND)).asType(DynamicViscosity.class), "Poise", "P");
    public static final Unit<KinematicViscosity> STOKES = CGS.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).pow(2).divide(SECOND).asType(KinematicViscosity.class), "Stokes", "St");
    public static final Unit<KinematicViscosity> KAYSER = CGS.addUnit(AbstractUnit.ONE.divide(CENTIMETRE).asType(KinematicViscosity.class), "Kayser", "cm\u207b\u00b9");

    private CGS() {
    }

    public static CGS getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        CGS.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)CGS.INSTANCE.units, unit, (String)name);
        }
        CGS.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return CGS.addUnit(unit, name, text, true);
    }
}

