/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import systems.microservice.log4j2.elasticsearch.appender.Buffer;
import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;

@Plugin(name="ElasticSearch", category="Core", elementType="appender", printObject=true)
public final class ElasticSearchAppender
extends AbstractAppender {
    public static final long PROCESS_ID = ElasticSearchAppender.createProcessID();
    public static final UUID PROCESS_UUID = ElasticSearchAppender.createProcessUUID();
    public static final long PROCESS_START_TIME = ElasticSearchAppender.createProcessStartTime();
    public static final Map<String, String> LOG_TAGS = ElasticSearchAppender.createLogTags();
    public static final String HOST_NAME = ElasticSearchAppender.createHostName();
    public static final String HOST_IP = ElasticSearchAppender.createHostIP();
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final AtomicBoolean flag = new AtomicBoolean(true);
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong totalSize = new AtomicLong(0L);
    private final AtomicLong lostCount = new AtomicLong(0L);
    private final AtomicLong lostSize = new AtomicLong(0L);
    private final String url;
    private final String index;
    private final boolean enable;
    private final int countMax;
    private final long sizeMax;
    private final int bulkCountMax;
    private final long bulkSizeMax;
    private final long delayMax;
    private final int bulkRetryCount;
    private final long bulkRetryDelay;
    private final int lengthStringMax;
    private final boolean out;
    private final boolean setDefaultUncaughtExceptionHandler;
    private final RestHighLevelClient client;
    private final Buffer buffer1;
    private final Buffer buffer2;
    private final Thread flushThread;

    public ElasticSearchAppender(String name, String url, String index, boolean enable, int countMax, long sizeMax, int bulkCountMax, long bulkSizeMax, long delayMax, int bulkRetryCount, long bulkRetryDelay, int lengthStringMax, boolean out, boolean setDefaultUncaughtExceptionHandler, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, (Layout)(layout != null ? layout : PatternLayout.createDefaultLayout()), false, Property.EMPTY_ARRAY);
        this.url = url;
        this.index = index;
        this.enable = enable;
        this.countMax = countMax;
        this.sizeMax = sizeMax;
        this.bulkCountMax = bulkCountMax;
        this.bulkSizeMax = bulkSizeMax;
        this.delayMax = delayMax * 1000L;
        this.bulkRetryCount = bulkRetryCount;
        this.bulkRetryDelay = bulkRetryDelay * 1000L;
        this.lengthStringMax = lengthStringMax;
        this.out = out;
        this.setDefaultUncaughtExceptionHandler = setDefaultUncaughtExceptionHandler;
        if (url != null && index != null && enable) {
            this.client = ElasticSearchAppender.createClient(url);
            this.buffer1 = new Buffer(countMax, sizeMax, bulkCountMax, bulkSizeMax, bulkRetryCount, bulkRetryDelay);
            this.buffer2 = new Buffer(countMax, sizeMax, bulkCountMax, bulkSizeMax, bulkRetryCount, bulkRetryDelay);
            if (setDefaultUncaughtExceptionHandler) {
                try {
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            try {
                                Logger l = LogManager.getLogger(ElasticSearchAppender.class);
                                l.error("Uncaught exception: ", e);
                            }
                            catch (Throwable ex) {
                                ElasticSearchAppender.logSystem(ElasticSearchAppender.this.out, ElasticSearchAppender.class, ex.getMessage());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                }
            }
            this.flushThread = new Thread(String.format("log4j2-elasticsearch-appender-flush-%s", name)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean enabled = ElasticSearchAppender.this.enabled;
                    AtomicBoolean flag = ElasticSearchAppender.this.flag;
                    AtomicLong totalCount = ElasticSearchAppender.this.totalCount;
                    AtomicLong totalSize = ElasticSearchAppender.this.totalSize;
                    AtomicLong lostCount = ElasticSearchAppender.this.lostCount;
                    AtomicLong lostSize = ElasticSearchAppender.this.lostSize;
                    String name = ElasticSearchAppender.this.getName();
                    String url = ElasticSearchAppender.this.url;
                    String index = ElasticSearchAppender.this.index;
                    boolean enable = ElasticSearchAppender.this.enable;
                    int countMax = ElasticSearchAppender.this.countMax;
                    long sizeMax = ElasticSearchAppender.this.sizeMax;
                    int bulkCountMax = ElasticSearchAppender.this.bulkCountMax;
                    long bulkSizeMax = ElasticSearchAppender.this.bulkSizeMax;
                    long delayMax = ElasticSearchAppender.this.delayMax;
                    int bulkRetryCount = ElasticSearchAppender.this.bulkRetryCount;
                    long bulkRetryDelay = ElasticSearchAppender.this.bulkRetryDelay;
                    int lengthStringMax = ElasticSearchAppender.this.lengthStringMax;
                    boolean out = ElasticSearchAppender.this.out;
                    boolean setDefaultUncaughtExceptionHandler = ElasticSearchAppender.this.setDefaultUncaughtExceptionHandler;
                    RestHighLevelClient client = ElasticSearchAppender.this.client;
                    Buffer buffer1 = ElasticSearchAppender.this.buffer1;
                    Buffer buffer2 = ElasticSearchAppender.this.buffer2;
                    try {
                        ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, String.format("Log4j2 ElasticSearch Appender is started: name='%s' url='%s' index='%s' enable=%b countMax=%d sizeMax=%d bulkCountMax=%d bulkSizeMax=%d delayMax=%d bulkRetryCount=%d bulkRetryDelay=%d lengthStringMax=%d out=%b setDefaultUncaughtExceptionHandler=%b", name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler));
                        long pt = System.currentTimeMillis();
                        while (enabled.get()) {
                            long t = System.currentTimeMillis();
                            if (t >= pt + delayMax) {
                                if (flag.get()) {
                                    try {
                                        flag.set(false);
                                        buffer1.flush(enabled, client, url, index, lostCount, lostSize, out);
                                    }
                                    catch (Throwable e) {
                                        ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                                    }
                                } else {
                                    try {
                                        flag.set(true);
                                        buffer2.flush(enabled, client, url, index, lostCount, lostSize, out);
                                    }
                                    catch (Throwable e) {
                                        ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                                    }
                                }
                                pt = t;
                            }
                            if (!buffer1.isReady()) {
                                try {
                                    flag.set(false);
                                    buffer1.flush(enabled, client, url, index, lostCount, lostSize, out);
                                }
                                catch (Throwable e) {
                                    ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                                }
                            }
                            if (!buffer2.isReady()) {
                                try {
                                    flag.set(true);
                                    buffer2.flush(enabled, client, url, index, lostCount, lostSize, out);
                                }
                                catch (Throwable e) {
                                    ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                                }
                            }
                            if (!enabled.get()) continue;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        try {
                            ElasticSearchAppender.this.append(new InputLogEvent(false, totalCount, totalSize, lostCount.get(), lostSize.get(), name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler));
                        }
                        catch (Throwable e) {
                            ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                        }
                        try {
                            flag.set(false);
                            buffer1.flush(enabled, client, url, index, lostCount, lostSize, out);
                        }
                        catch (Throwable e) {
                            ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                        }
                        try {
                            flag.set(true);
                            buffer2.flush(enabled, client, url, index, lostCount, lostSize, out);
                        }
                        catch (Throwable e) {
                            ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, String.format("Log4j2 ElasticSearch Appender is finished: name='%s' url='%s' index='%s' enable=%b countMax=%d sizeMax=%d bulkCountMax=%d bulkSizeMax=%d delayMax=%d bulkRetryCount=%d bulkRetryDelay=%d lengthStringMax=%d out=%b setDefaultUncaughtExceptionHandler=%b totalCount=%d totalSize=%d lostCount=%d lostSize=%d", name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler, totalCount.get(), totalSize.get(), lostCount.get(), lostSize.get()));
                        throw throwable;
                    }
                    ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, String.format("Log4j2 ElasticSearch Appender is finished: name='%s' url='%s' index='%s' enable=%b countMax=%d sizeMax=%d bulkCountMax=%d bulkSizeMax=%d delayMax=%d bulkRetryCount=%d bulkRetryDelay=%d lengthStringMax=%d out=%b setDefaultUncaughtExceptionHandler=%b totalCount=%d totalSize=%d lostCount=%d lostSize=%d", name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler, totalCount.get(), totalSize.get(), lostCount.get(), lostSize.get()));
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(String.format("log4j2-elasticsearch-appender-shutdown-%s", name)){

                    @Override
                    public void run() {
                        AtomicBoolean enabled = ElasticSearchAppender.this.enabled;
                        Thread flushThread = ElasticSearchAppender.this.flushThread;
                        enabled.set(false);
                        if (flushThread.isAlive()) {
                            flushThread.interrupt();
                            try {
                                flushThread.join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, e.getMessage());
            }
            this.append(new InputLogEvent(true, this.totalCount, this.totalSize, this.lostCount.get(), this.lostSize.get(), name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler));
            ElasticSearchAppender.logSystem(out, ElasticSearchAppender.class, String.format("Log4j2 ElasticSearch Appender is initialized: name='%s' url='%s' index='%s' enable=%b countMax=%d sizeMax=%d bulkCountMax=%d bulkSizeMax=%d delayMax=%d bulkRetryCount=%d bulkRetryDelay=%d lengthStringMax=%d out=%b setDefaultUncaughtExceptionHandler=%b", name, url, index, enable, countMax, sizeMax, bulkCountMax, bulkSizeMax, delayMax, bulkRetryCount, bulkRetryDelay, lengthStringMax, out, setDefaultUncaughtExceptionHandler));
        } else {
            this.client = null;
            this.buffer1 = null;
            this.buffer2 = null;
            this.flushThread = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public String getIndex() {
        return this.index;
    }

    public void start() {
        super.start();
        if (this.flushThread != null) {
            this.enabled.set(true);
            this.flushThread.setDaemon(false);
            this.flushThread.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.flushThread != null) {
            this.enabled.set(false);
            if (this.flushThread.isAlive()) {
                this.flushThread.interrupt();
                try {
                    this.flushThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void append(LogEvent event) {
        if (this.enabled.get()) {
            String l = event.getLoggerName();
            if (l != null && l.startsWith("org.apache.http.")) {
                return;
            }
            String t = event.getThreadName();
            if (t != null && t.startsWith("log4j2-elasticsearch-appender-flush-")) {
                return;
            }
            this.append(new InputLogEvent(event, this.totalCount, this.totalSize, this.lostCount.get(), this.lostSize.get(), this.lengthStringMax));
        }
    }

    private void append(InputLogEvent event) {
        if (this.flag.get()) {
            if (!this.buffer1.append(event) && !this.buffer2.append(event)) {
                this.lostCount.incrementAndGet();
                this.lostSize.addAndGet(event.size);
            }
        } else if (!this.buffer2.append(event) && !this.buffer1.append(event)) {
            this.lostCount.incrementAndGet();
            this.lostSize.addAndGet(event.size);
        }
    }

    @PluginFactory
    public static ElasticSearchAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="url") String url, @PluginAttribute(value="index") String index, @PluginAttribute(value="enable") String enable, @PluginAttribute(value="countMax") String countMax, @PluginAttribute(value="sizeMax") String sizeMax, @PluginAttribute(value="bulkCountMax") String bulkCountMax, @PluginAttribute(value="bulkSizeMax") String bulkSizeMax, @PluginAttribute(value="delayMax") String delayMax, @PluginAttribute(value="bulkRetryCount") String bulkRetryCount, @PluginAttribute(value="bulkRetryDelay") String bulkRetryDelay, @PluginAttribute(value="lengthStringMax") String lengthStringMax, @PluginAttribute(value="out") String out, @PluginAttribute(value="setDefaultUncaughtExceptionHandler") String setDefaultUncaughtExceptionHandler, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new ElasticSearchAppender(name != null ? name : "elasticsearch", ElasticSearchAppender.getProperty("log4j2.elasticsearch.url", "LOG4J2_ELASTICSEARCH_URL", url, null), ElasticSearchAppender.getProperty("log4j2.elasticsearch.index", "LOG4J2_ELASTICSEARCH_INDEX", index, null), Boolean.parseBoolean(ElasticSearchAppender.getProperty("log4j2.elasticsearch.enable", "LOG4J2_ELASTICSEARCH_ENABLE", enable, "true")), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.count.max", "LOG4J2_ELASTICSEARCH_COUNT_MAX", countMax, "10000")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.size.max", "LOG4J2_ELASTICSEARCH_SIZE_MAX", sizeMax, "5242880")), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.bulk.count.max", "LOG4J2_ELASTICSEARCH_BULK_COUNT_MAX", bulkCountMax, "4000")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.bulk.size.max", "LOG4J2_ELASTICSEARCH_BULK_SIZE_MAX", bulkSizeMax, "2097152")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.delay.max", "LOG4J2_ELASTICSEARCH_DELAY_MAX", delayMax, "60")), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.bulk.retry.count", "LOG4J2_ELASTICSEARCH_BULK_RETRY_COUNT", bulkRetryCount, "5")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.bulk.retry.delay", "LOG4J2_ELASTICSEARCH_BULK_RETRY_DELAY", bulkRetryDelay, "5")), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.length.string.max", "LOG4J2_ELASTICSEARCH_LENGTH_STRING_MAX", lengthStringMax, "65536")), Boolean.parseBoolean(ElasticSearchAppender.getProperty("log4j2.elasticsearch.out", "LOG4J2_ELASTICSEARCH_OUT", out, "true")), Boolean.parseBoolean(ElasticSearchAppender.getProperty("log4j2.elasticsearch.set.default.uncaught.exception.handler", "LOG4J2_ELASTICSEARCH_SET_DEFAULT_UNCAUGHT_EXCEPTION_HANDLER", setDefaultUncaughtExceptionHandler, "true")), filter, layout);
    }

    public static void logSystem(boolean out, Class clazz, String message) {
        if (out) {
            if (clazz == null) {
                clazz = ElasticSearchAppender.class;
            }
            if (message == null) {
                message = "null";
            }
            String t = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL", System.currentTimeMillis());
            System.out.println(String.format("%s [%s] [%s] SYSTEM - %s", t, Thread.currentThread().getName(), clazz.getSimpleName(), message));
        }
    }

    private static long createProcessID() {
        String[] ns;
        String n = ManagementFactory.getRuntimeMXBean().getName();
        if (n != null && (ns = n.split("@")).length > 0) {
            try {
                return Long.parseLong(ns[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static UUID createProcessUUID() {
        return new UUID(new SecureRandom().nextLong(), 0L);
    }

    private static long createProcessStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private static Map<String, String> createLogTags() {
        Object v;
        Object k;
        String PREFIX_EV = "LOGTAG_";
        String PREFIX_SP = "logtag.";
        Map<String, String> evs = System.getenv();
        Properties sps = System.getProperties();
        LinkedHashMap<String, Object> lts = new LinkedHashMap<String, Object>(evs.size() + sps.size());
        for (Map.Entry<String, String> entry : evs.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            if (k == null || v == null || ((String)(k = ((String)k).trim())).length() <= "LOGTAG_".length() || !((String)k).startsWith("LOGTAG_")) continue;
            lts.put(((String)k).substring("LOGTAG_".length()).replace('_', '.').toLowerCase(), v);
        }
        for (Map.Entry<Object, Object> entry : sps.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            if (k == null || v == null || !(k instanceof String) || !(v instanceof String)) continue;
            String ks = ((String)k).trim();
            String vs = (String)v;
            if (ks.length() <= "logtag.".length() || !ks.startsWith("logtag.")) continue;
            lts.put(ks.substring("logtag.".length()).replace('_', '.').toLowerCase(), vs);
        }
        return Collections.unmodifiableMap(lts);
    }

    private static String createHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String createHostIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String getProperty(String property, String variable, String value) {
        String v = ElasticSearchAppender.getProperty(property, variable, value, null);
        if (v != null) {
            return v;
        }
        throw new RuntimeException(String.format("Property ['%s', '%s'] is not defined", property, variable));
    }

    private static String getProperty(String property, String variable, String value, String def) {
        String v = System.getProperty(property);
        if (v != null) {
            return v;
        }
        v = System.getenv(variable);
        if (v != null) {
            return v;
        }
        if (value != null) {
            return value;
        }
        return def;
    }

    private static RestHighLevelClient createClient(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        String[] us = url.split(";");
        if (us.length <= 0) {
            throw new IllegalArgumentException("url should contain at least one URL to ElasticSearch host");
        }
        try {
            HttpHost[] hs = new HttpHost[us.length];
            int ci = us.length;
            for (int i = 0; i < ci; ++i) {
                URL ur = new URL(us[i].trim());
                hs[i] = new HttpHost(ur.getHost(), ur.getPort(), ur.getProtocol());
            }
            return new RestHighLevelClient(RestClient.builder((HttpHost[])hs));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

