/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadSection {
    private final AtomicBoolean enabled;
    private final AtomicLong threads = new AtomicLong(0L);

    public ThreadSection(boolean enabled) {
        this.enabled = new AtomicBoolean(enabled);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean isDisabled() {
        return !this.enabled.get() && this.threads.get() == 0L;
    }

    public boolean enable() {
        return this.enabled.compareAndSet(false, true);
    }

    public boolean disable() {
        return this.enabled.compareAndSet(true, false);
    }

    public void await(long millis) {
        while (!this.isDisabled()) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean enter() {
        if (this.enabled.get()) {
            this.threads.incrementAndGet();
            if (this.enabled.get()) {
                return true;
            }
            this.threads.decrementAndGet();
            return false;
        }
        return false;
    }

    public void leave() {
        long ts = this.threads.decrementAndGet();
        if (ts < 0L) {
            this.threads.incrementAndGet();
            throw new IllegalStateException(String.format("Illegal enter/leave calls: %d", ts));
        }
    }
}

