/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import systems.microservice.log4j2.elasticsearch.appender.ByteArrayOutputStream;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Util;

final class InputLogEvent
extends UpdateRequest
implements Comparable<InputLogEvent> {
    private static final int SIZE_OVERHEAD = 32;
    private static final long mostSigBits = new SecureRandom().nextLong();
    private static final AtomicLong leastSigBits = new AtomicLong(0L);
    public final long time;
    public final int size;

    public InputLogEvent(boolean start, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize) {
        super(null, new UUID(mostSigBits, leastSigBits.incrementAndGet()).toString());
        this.time = start ? ElasticSearchAppender.PROCESS_START_TIME : System.currentTimeMillis();
        this.docAsUpsert(true);
        try {
            Thread t = Thread.currentThread();
            ByteArrayOutputStream buf = new ByteArrayOutputStream(131072);
            XContentBuilder cb = XContentFactory.smileBuilder((OutputStream)((Object)buf));
            cb.humanReadable(true);
            cb.startObject();
            cb.timeField("time", (Object)this.time);
            if (start) {
                cb.field("type", "START");
            } else {
                cb.field("type", "FINISH");
            }
            cb.field("process.id", ElasticSearchAppender.PROCESS_ID);
            cb.timeField("process.start.time", (Object)ElasticSearchAppender.PROCESS_START_TIME);
            if (!start) {
                cb.timeField("process.finish.time", (Object)this.time);
            }
            InputLogEvent.addField(cb, "process.cmdline", Util.loadString(String.format("/proc/%d/cmdline", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            InputLogEvent.addField(cb, "process.io", Util.loadString(String.format("/proc/%d/io", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            InputLogEvent.addField(cb, "process.limits", Util.loadString(String.format("/proc/%d/limits", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            InputLogEvent.addField(cb, "process.mounts", Util.loadString(String.format("/proc/%d/mounts", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            InputLogEvent.addField(cb, "process.net.dev", Util.loadString(String.format("/proc/%d/net/dev", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            InputLogEvent.addField(cb, "process.net.protocols", Util.loadString(String.format("/proc/%d/net/protocols", ElasticSearchAppender.PROCESS_ID), "unknown"), 65536);
            for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                cb.field(e.getKey(), e.getValue());
            }
            cb.field("host.name", ElasticSearchAppender.HOST_NAME);
            cb.field("host.ip", ElasticSearchAppender.HOST_IP);
            cb.field("logger", ElasticSearchAppender.class.getName());
            cb.field("thread.id", t.getId());
            InputLogEvent.addField(cb, "thread.name", t.getName(), 256);
            cb.field("thread.priority", t.getPriority());
            cb.field("level", "INFO");
            if (start) {
                cb.field("message", "Hello World!");
            } else {
                cb.field("message", "Goodbye World!");
            }
            cb.field("environment.variables", ElasticSearchAppender.ENVIRONMENT_VARIABLES);
            cb.field("system.properties", ElasticSearchAppender.SYSTEM_PROPERTIES);
            this.size = buf.size() + 32;
            cb.field("size", this.size);
            cb.field("total.count", totalCount.incrementAndGet());
            cb.field("total.size", totalSize.addAndGet(this.size));
            cb.field("lost.count", lostCount);
            cb.field("lost.size", lostSize);
            cb.endObject();
            this.doc(cb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputLogEvent(LogEvent event, int lengthMax, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize) {
        super(null, new UUID(mostSigBits, leastSigBits.incrementAndGet()).toString());
        this.time = event.getTimeMillis();
        this.docAsUpsert(true);
        try {
            ReadOnlyStringMap ctx;
            Marker mrk;
            StackTraceElement ste;
            Throwable ex = event.getThrown();
            ByteArrayOutputStream buf = new ByteArrayOutputStream(ex == null ? 512 : 1024);
            XContentBuilder cb = XContentFactory.smileBuilder((OutputStream)((Object)buf));
            cb.humanReadable(true);
            cb.startObject();
            cb.timeField("time", (Object)this.time);
            cb.field("type", ex == null ? "DEFAULT" : "EXCEPTION");
            cb.field("process.id", ElasticSearchAppender.PROCESS_ID);
            cb.timeField("process.start.time", (Object)ElasticSearchAppender.PROCESS_START_TIME);
            for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                cb.field(e.getKey(), e.getValue());
            }
            cb.field("host.name", ElasticSearchAppender.HOST_NAME);
            cb.field("host.ip", ElasticSearchAppender.HOST_IP);
            InputLogEvent.addField(cb, "logger", event.getLoggerFqcn(), 256);
            cb.field("thread.id", event.getThreadId());
            InputLogEvent.addField(cb, "thread.name", event.getThreadName(), 256);
            cb.field("thread.priority", event.getThreadPriority());
            Level l = event.getLevel();
            if (l != null) {
                InputLogEvent.addField(cb, "level", l.toString(), 32);
            } else {
                cb.field("level", "INFO");
            }
            Message m = event.getMessage();
            if (m != null) {
                InputLogEvent.addField(cb, "message", m.getFormattedMessage(), lengthMax);
            }
            if ((ste = event.getSource()) != null) {
                InputLogEvent.addField(cb, "src.file", ste.getFileName(), 256);
                InputLogEvent.addField(cb, "src.class", ste.getClassName(), 256);
                InputLogEvent.addField(cb, "src.method", ste.getMethodName(), 256);
                cb.field("src.line", ste.getLineNumber());
            }
            if (ex != null) {
                Throwable cex;
                InputLogEvent.addField(cb, "exception.class", ex.getClass().getName(), 256);
                InputLogEvent.addField(cb, "exception.message", ex.getMessage(), lengthMax);
                try (StringBuilderWriter sbw = new StringBuilderWriter(1024);){
                    ex.printStackTrace(new PrintWriter((Writer)sbw, false));
                    InputLogEvent.addField(cb, "exception.stacktrace", sbw.toString(), lengthMax);
                }
                Throwable[] sex = ex.getSuppressed();
                if (sex != null) {
                    cb.field("exception.suppressed.count", sex.length);
                }
                if ((cex = ex.getCause()) != null) {
                    InputLogEvent.addField(cb, "exception.cause.class", cex.getClass().getName(), 256);
                    InputLogEvent.addField(cb, "exception.cause.message", cex.getMessage(), lengthMax);
                }
            }
            if ((mrk = event.getMarker()) != null) {
                InputLogEvent.addField(cb, "marker.name", mrk.getName(), 256);
                cb.field("marker.parents", mrk.hasParents());
            }
            if ((ctx = event.getContextData()) != null) {
                try {
                    ctx.forEach((k, v) -> {
                        if (k != null && v != null) {
                            InputLogEvent.addField(cb, "ctx." + k, v.toString(), 256);
                        }
                    });
                }
                catch (Exception e) {
                    InputLogEvent.addField(cb, "ctx.exception.class", e.getClass().getName(), 256);
                    InputLogEvent.addField(cb, "ctx.exception.message", e.getMessage(), lengthMax);
                }
            }
            this.size = buf.size() + 32;
            cb.field("size", this.size);
            cb.field("total.count", totalCount.incrementAndGet());
            cb.field("total.size", totalSize.addAndGet(this.size));
            cb.field("lost.count", lostCount);
            cb.field("lost.size", lostSize);
            cb.endObject();
            this.doc(cb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(InputLogEvent event) {
        if (this.time < event.time) {
            return -1;
        }
        if (this.time > event.time) {
            return 1;
        }
        return 0;
    }

    private static void addField(XContentBuilder builder, String name, String value, int lengthMax) {
        if (name != null && value != null) {
            try {
                builder.field(name, Util.cut(value, lengthMax));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

