/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import systems.microservice.log4j2.elasticsearch.appender.Buffer;
import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;

@Plugin(name="ElasticSearch", category="Core", elementType="appender", printObject=true)
public final class ElasticSearchAppender
extends AbstractAppender {
    public static final long PROCESS_ID = ElasticSearchAppender.createProcessID();
    public static final long PROCESS_START_TIME = ElasticSearchAppender.createProcessStartTime();
    public static final Map<String, String> LOG_TAGS = ElasticSearchAppender.createLogTags();
    public static final String HOST_NAME = ElasticSearchAppender.createHostName();
    public static final String HOST_IP = ElasticSearchAppender.createHostIP();
    public static final String ENVIRONMENT_VARIABLES = ElasticSearchAppender.createEnvironmentVariables();
    public static final String SYSTEM_PROPERTIES = ElasticSearchAppender.createSystemProperties();
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final AtomicBoolean flag = new AtomicBoolean(true);
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong totalSize = new AtomicLong(0L);
    private final AtomicLong lostCount = new AtomicLong(0L);
    private final AtomicLong lostSize = new AtomicLong(0L);
    private final String url;
    private final String index;
    private final int countMax;
    private final long sizeMax;
    private final int lengthMax;
    private final long spanMax;
    private final RestHighLevelClient client;
    private final Buffer buffer1;
    private final Buffer buffer2;
    private final Thread flushThread;

    public ElasticSearchAppender(String name, String url, String index, int countMax, long sizeMax, int lengthMax, long spanMax, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, (Layout)(layout != null ? layout : PatternLayout.createDefaultLayout()), false, Property.EMPTY_ARRAY);
        if (url != null && index != null) {
            this.url = url;
            this.index = index;
            this.countMax = countMax;
            this.sizeMax = sizeMax;
            this.lengthMax = lengthMax;
            this.spanMax = spanMax * 1000L;
            this.client = ElasticSearchAppender.createClient(url);
            this.buffer1 = new Buffer(countMax, sizeMax);
            this.buffer2 = new Buffer(countMax, sizeMax);
            this.flushThread = new Thread(String.format("log4j2-elasticsearch-appender-flush-%s", name)){

                @Override
                public void run() {
                    AtomicBoolean enabled = ElasticSearchAppender.this.enabled;
                    AtomicBoolean flag = ElasticSearchAppender.this.flag;
                    AtomicLong totalCount = ElasticSearchAppender.this.totalCount;
                    AtomicLong totalSize = ElasticSearchAppender.this.totalSize;
                    AtomicLong lostCount = ElasticSearchAppender.this.lostCount;
                    AtomicLong lostSize = ElasticSearchAppender.this.lostSize;
                    String url = ElasticSearchAppender.this.url;
                    String index = ElasticSearchAppender.this.index;
                    long spanMax = ElasticSearchAppender.this.spanMax;
                    RestHighLevelClient client = ElasticSearchAppender.this.client;
                    Buffer buffer1 = ElasticSearchAppender.this.buffer1;
                    Buffer buffer2 = ElasticSearchAppender.this.buffer2;
                    long pt = System.currentTimeMillis();
                    while (enabled.get()) {
                        long t = System.currentTimeMillis();
                        if (t >= pt + spanMax) {
                            if (flag.get()) {
                                try {
                                    flag.set(false);
                                    buffer1.flush(client, url, index, lostCount, lostSize);
                                }
                                catch (Throwable e) {
                                    ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                                }
                            } else {
                                try {
                                    flag.set(true);
                                    buffer2.flush(client, url, index, lostCount, lostSize);
                                }
                                catch (Throwable e) {
                                    ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                                }
                            }
                            pt = t;
                        }
                        if (!buffer1.isReady()) {
                            try {
                                flag.set(false);
                                buffer1.flush(client, url, index, lostCount, lostSize);
                            }
                            catch (Throwable e) {
                                ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                            }
                        }
                        if (!buffer2.isReady()) {
                            try {
                                flag.set(true);
                                buffer2.flush(client, url, index, lostCount, lostSize);
                            }
                            catch (Throwable e) {
                                ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        ElasticSearchAppender.this.append(new InputLogEvent(false, totalCount, totalSize, lostCount.get(), lostSize.get()));
                    }
                    catch (Throwable e) {
                        ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                    }
                    try {
                        flag.set(false);
                        buffer1.flush(client, url, index, lostCount, lostSize);
                    }
                    catch (Throwable e) {
                        ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                    }
                    try {
                        flag.set(true);
                        buffer2.flush(client, url, index, lostCount, lostSize);
                    }
                    catch (Throwable e) {
                        ElasticSearchAppender.logSystem(ElasticSearchAppender.class, e.getMessage());
                    }
                }
            };
            this.append(new InputLogEvent(true, this.totalCount, this.totalSize, this.lostCount.get(), this.lostSize.get()));
            Runtime.getRuntime().addShutdownHook(new Thread(String.format("log4j2-elasticsearch-appender-shutdown-%s", name)){

                @Override
                public void run() {
                    AtomicBoolean enabled = ElasticSearchAppender.this.enabled;
                    Thread flushThread = ElasticSearchAppender.this.flushThread;
                    enabled.set(false);
                    if (flushThread.isAlive()) {
                        flushThread.interrupt();
                        try {
                            flushThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            this.url = url;
            this.index = null;
            this.countMax = 0;
            this.sizeMax = 0L;
            this.lengthMax = 0;
            this.spanMax = 0L;
            this.client = null;
            this.buffer1 = null;
            this.buffer2 = null;
            this.flushThread = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public String getIndex() {
        return this.index;
    }

    public int getCountMax() {
        return this.countMax;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public int getLengthMax() {
        return this.lengthMax;
    }

    public long getSpanMax() {
        return this.spanMax;
    }

    public void start() {
        super.start();
        if (this.url != null && this.index != null) {
            this.enabled.set(true);
            this.flushThread.setDaemon(false);
            this.flushThread.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.url != null && this.index != null) {
            this.enabled.set(false);
            this.flushThread.interrupt();
            try {
                this.flushThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void append(LogEvent event) {
        if (this.enabled.get()) {
            this.append(new InputLogEvent(event, this.lengthMax, this.totalCount, this.totalSize, this.lostCount.get(), this.lostSize.get()));
        }
    }

    private void append(InputLogEvent event) {
        if (this.flag.get()) {
            if (!this.buffer1.append(event) && !this.buffer2.append(event)) {
                this.lostCount.incrementAndGet();
            }
        } else if (!this.buffer2.append(event) && !this.buffer1.append(event)) {
            this.lostCount.incrementAndGet();
        }
    }

    @PluginFactory
    public static ElasticSearchAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="url") String url, @PluginAttribute(value="index") String index, @PluginAttribute(value="countMax") String countMax, @PluginAttribute(value="sizeMax") String sizeMax, @PluginAttribute(value="lengthMax") String lengthMax, @PluginAttribute(value="spanMax") String spanMax, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new ElasticSearchAppender(name != null ? name : "elasticsearch", ElasticSearchAppender.getProperty("log4j2.elasticsearch.url", "LOG4J2_ELASTICSEARCH_URL", url, null), ElasticSearchAppender.getProperty("log4j2.elasticsearch.index", "LOG4J2_ELASTICSEARCH_INDEX", index, null), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.count.max", "LOG4J2_ELASTICSEARCH_COUNT_MAX", countMax, "10000")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.size.max", "LOG4J2_ELASTICSEARCH_SIZE_MAX", sizeMax, "5242880")), Integer.parseInt(ElasticSearchAppender.getProperty("log4j2.elasticsearch.length.max", "LOG4J2_ELASTICSEARCH_LENGTH_MAX", lengthMax, "4096")), Long.parseLong(ElasticSearchAppender.getProperty("log4j2.elasticsearch.span.max", "LOG4J2_ELASTICSEARCH_SPAN_MAX", spanMax, "60")), filter, layout);
    }

    public static void logSystem(Class clazz, String message) {
        if (clazz == null) {
            clazz = ElasticSearchAppender.class;
        }
        if (message == null) {
            message = "null";
        }
        String t = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL", System.currentTimeMillis());
        System.out.println(String.format("%s [%s] [%s] SYSTEM - %s", t, Thread.currentThread().getName(), clazz.getSimpleName(), message));
    }

    private static long createProcessID() {
        String[] ns;
        String n = ManagementFactory.getRuntimeMXBean().getName();
        if (n != null && (ns = n.split("@")).length > 0) {
            try {
                return Long.parseLong(ns[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static long createProcessStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private static Map<String, String> createLogTags() {
        Object v;
        Object k;
        String PREFIX_EV = "LOGTAG_";
        String PREFIX_SP = "logtag.";
        Map<String, String> evs = System.getenv();
        Properties sps = System.getProperties();
        LinkedHashMap<String, Object> lts = new LinkedHashMap<String, Object>(evs.size() + sps.size());
        for (Map.Entry<String, String> entry : evs.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            if (k == null || v == null || ((String)(k = ((String)k).trim())).length() <= "LOGTAG_".length() || !((String)k).startsWith("LOGTAG_")) continue;
            lts.put(((String)k).substring("LOGTAG_".length()).replace('_', '.').toLowerCase(), v);
        }
        for (Map.Entry<Object, Object> entry : sps.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            if (k == null || v == null || !(k instanceof String) || !(v instanceof String)) continue;
            String ks = ((String)k).trim();
            String vs = (String)v;
            if (ks.length() <= "logtag.".length() || !ks.startsWith("logtag.")) continue;
            lts.put(ks.substring("logtag.".length()).replace('_', '.').toLowerCase(), vs);
        }
        return Collections.unmodifiableMap(lts);
    }

    private static String createHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String createHostIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String createEnvironmentVariables() {
        Map<String, String> evs = System.getenv();
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry<String, String> e : evs.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (k == null || v == null) continue;
            sb.append(k);
            sb.append("=");
            sb.append(v);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String createSystemProperties() {
        Properties sps = System.getProperties();
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry<Object, Object> e : sps.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null || !(k instanceof String) || !(v instanceof String)) continue;
            String ks = (String)k;
            String vs = (String)v;
            sb.append(ks);
            sb.append("=");
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getProperty(String property, String variable, String value) {
        String v = ElasticSearchAppender.getProperty(property, variable, value, null);
        if (v != null) {
            return v;
        }
        throw new RuntimeException(String.format("Property ['%s', '%s'] is not defined", property, variable));
    }

    private static String getProperty(String property, String variable, String value, String def) {
        String v = System.getProperty(property);
        if (v != null) {
            return v;
        }
        v = System.getenv(variable);
        if (v != null) {
            return v;
        }
        if (value != null) {
            return value;
        }
        return def;
    }

    private static RestHighLevelClient createClient(String url) {
        try {
            URL u = new URL(url);
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(u.getHost(), u.getPort(), u.getProtocol())}));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

