/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Index;
import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;
import systems.microservice.log4j2.elasticsearch.appender.ThreadSection;

final class Buffer {
    public static final int BULK_RETRIES = 5;
    public static final long BULK_RETRIES_SPAN = 5000L;
    public static final int BULK_COUNT_MAX = 4000;
    public static final long BULK_SIZE_MAX = 0x200000L;
    private final ThreadSection section = new ThreadSection(true);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong size = new AtomicLong(0L);
    private final int countMax;
    private final long sizeMax;
    private final ConcurrentLinkedQueue<InputLogEvent> eventsQueue;
    private final ArrayList<InputLogEvent> eventsList;

    public Buffer(int countMax, long sizeMax) {
        this.countMax = countMax;
        this.sizeMax = sizeMax;
        this.eventsQueue = new ConcurrentLinkedQueue();
        this.eventsList = new ArrayList(countMax + 1);
    }

    public boolean isReady() {
        return this.section.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(InputLogEvent event) {
        if (this.section.enter()) {
            try {
                if (this.count.get() + 1 < this.countMax) {
                    long s;
                    int c;
                    long es = event.size;
                    if (this.size.get() + es < this.sizeMax && (c = this.count.incrementAndGet()) < this.countMax && (s = this.size.addAndGet(es)) < this.sizeMax) {
                        this.eventsQueue.offer(event);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.section.leave();
            }
            this.section.disable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RestHighLevelClient client, String url, String index, AtomicLong lostCount, AtomicLong lostSize) {
        block10: {
            this.section.disable();
            try {
                this.section.await(100L);
                if (this.count.get() <= 0) break block10;
                try {
                    for (InputLogEvent e : this.eventsQueue) {
                        this.eventsList.add(e);
                    }
                    Collections.sort(this.eventsList);
                    Index idx = null;
                    BulkRequest r = new BulkRequest(null);
                    for (InputLogEvent e : this.eventsList) {
                        if (idx == null || !idx.contains(e)) {
                            idx = new Index(index, e);
                        }
                        e.index(idx.name);
                        if (r.numberOfActions() < 4000 && r.estimatedSizeInBytes() < 0x200000L) {
                            r.add((UpdateRequest)e);
                            continue;
                        }
                        lostCount.addAndGet(this.putEvents(client, url, index, r));
                        r = new BulkRequest(null);
                        r.add((UpdateRequest)e);
                    }
                    lostCount.addAndGet(this.putEvents(client, url, index, r));
                }
                finally {
                    this.eventsList.clear();
                    this.eventsQueue.clear();
                    this.size.set(0L);
                    this.count.set(0);
                }
            }
            finally {
                this.section.enable();
            }
        }
    }

    private int putEvents(RestHighLevelClient client, String url, String index, BulkRequest request) {
        int fc = 0;
        for (int i = 0; request.numberOfActions() > 0 && i < 5; ++i) {
            try {
                BulkItemResponse[] irs;
                BulkResponse rsp = client.bulk(request, RequestOptions.DEFAULT);
                fc = 0;
                for (BulkItemResponse ir : irs = rsp.getItems()) {
                    if (!ir.isFailed()) continue;
                    ++fc;
                }
                if (fc == 0) {
                    return 0;
                }
                ElasticSearchAppender.logSystem(Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s) contains %d failed events", i, request.numberOfActions(), url, index, fc));
                HashSet<String> fids = new HashSet<String>(Math.max(fc, 16));
                for (BulkItemResponse ir : irs) {
                    fids.add(ir.getId());
                }
                BulkRequest r = new BulkRequest(null);
                List es = request.requests();
                for (DocWriteRequest e : es) {
                    if (!fids.contains(e.id())) continue;
                    r.add(e);
                }
                request = r;
            }
            catch (Exception e) {
                ElasticSearchAppender.logSystem(Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s) is failed with %s: %s", i, request.numberOfActions(), url, index, e.getClass().getSimpleName(), e.getMessage()));
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return fc;
    }
}

