/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class JsonUtil {
    private static final JsonFactory factory = new JsonFactory();
    private static final ObjectMapper mapper = new ObjectMapper(factory);

    private JsonUtil() {
    }

    public static byte[] toBytes(Object value) {
        try {
            return mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromBytes(byte[] data, Class<T> type) {
        try {
            return (T)mapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(OutputStream output, Object value) {
        try {
            mapper.writeValue(output, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readBytes(InputStream input, Class<T> type) {
        try {
            return (T)mapper.readValue(input, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromString(String content, Class<T> type) {
        try {
            return (T)mapper.readValue(content, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

