/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import systems.microservice.log4j2.elasticsearch.appender.BulkRequest;
import systems.microservice.log4j2.elasticsearch.appender.BulkResponse;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Index;
import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;
import systems.microservice.log4j2.elasticsearch.appender.JsonUtil;
import systems.microservice.log4j2.elasticsearch.appender.RestHighLevelClient;
import systems.microservice.log4j2.elasticsearch.appender.ThreadSection;
import systems.microservice.log4j2.elasticsearch.appender.Util;

final class Buffer {
    private final ThreadSection section = new ThreadSection(true);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong size = new AtomicLong(0L);
    private final int countMax;
    private final long sizeMax;
    private final int bulkCountMax;
    private final long bulkSizeMax;
    private final int bulkRetryCount;
    private final long bulkRetryDelay;
    private final ConcurrentLinkedQueue<InputLogEvent> eventsQueue;
    private final ArrayList<InputLogEvent> eventsList;

    public Buffer(int countMax, long sizeMax, int bulkCountMax, long bulkSizeMax, int bulkRetryCount, long bulkRetryDelay) {
        this.countMax = countMax;
        this.sizeMax = sizeMax;
        this.bulkCountMax = bulkCountMax;
        this.bulkSizeMax = bulkSizeMax;
        this.bulkRetryCount = bulkRetryCount;
        this.bulkRetryDelay = bulkRetryDelay;
        this.eventsQueue = new ConcurrentLinkedQueue();
        this.eventsList = new ArrayList(countMax);
    }

    public boolean isReady() {
        return this.section.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(InputLogEvent event) {
        if (this.section.enter()) {
            try {
                if (this.count.get() + 1 < this.countMax) {
                    long s;
                    int c;
                    long es = event.size;
                    if (this.size.get() + es < this.sizeMax && (c = this.count.incrementAndGet()) < this.countMax && (s = this.size.addAndGet(es)) < this.sizeMax) {
                        this.eventsQueue.offer(event);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.section.leave();
            }
            this.section.disable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(AtomicBoolean enabled, RestHighLevelClient client, String name, String url, String user, String index, int buffer, AtomicLong lostCount, AtomicLong lostSize, boolean out, boolean debug) {
        if (debug) {
            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("[BEGIN]: public void Buffer.flush(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b)", enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug));
        }
        try {
            block13: {
                this.section.disable();
                try {
                    this.section.await();
                    if (this.count.get() <= 0) break block13;
                    try {
                        for (InputLogEvent e : this.eventsQueue) {
                            this.eventsList.add(e);
                        }
                        Collections.sort(this.eventsList);
                        Index idx = null;
                        int bc = 0;
                        long bs = 0L;
                        BulkRequest r = new BulkRequest(this.bulkCountMax);
                        for (InputLogEvent e : this.eventsList) {
                            if (idx == null || !idx.contains(e)) {
                                idx = new Index(index, e);
                            }
                            e.index = idx.name;
                            if (bc >= this.bulkCountMax || bs >= this.bulkSizeMax) {
                                this.putEvents(enabled, client, name, url, user, index, buffer, lostCount, lostSize, out, debug, r);
                                r = new BulkRequest(this.bulkCountMax);
                                bc = 0;
                                bs = 0L;
                            }
                            r.add(e);
                            ++bc;
                            bs += (long)e.size;
                        }
                        this.putEvents(enabled, client, name, url, user, index, buffer, lostCount, lostSize, out, debug, r);
                    }
                    finally {
                        this.eventsList.clear();
                        this.eventsQueue.clear();
                        this.size.set(0L);
                        this.count.set(0);
                    }
                }
                finally {
                    this.section.enable();
                }
            }
            if (!debug) return;
        }
        catch (Throwable throwable) {
            if (!debug) throw throwable;
            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("[END]: public void Buffer.flush(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b)", enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug));
            throw throwable;
        }
        ElasticSearchAppender.logSystem(out, Buffer.class, String.format("[END]: public void Buffer.flush(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b)", enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void putEvents(AtomicBoolean enabled, RestHighLevelClient client, String name, String url, String user, String index, int buffer, AtomicLong lostCount, AtomicLong lostSize, boolean out, boolean debug, BulkRequest request) {
        block28: {
            block27: {
                block30: {
                    block31: {
                        block29: {
                            if (debug) {
                                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [BEGIN]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
                            }
                            try {
                                fc = 0;
                                fs = 0L;
                                try {
                                    i = 0;
lbl8:
                                    // 2 sources

                                    while (request.numberOfActions() > 0 && i < this.bulkRetryCount) {
                                        if (debug) {
                                            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [BEGIN]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                                        }
                                        try {
                                            rsp = null;
                                            try {
                                                rsp = client.bulk(request);
                                                ** GOTO lbl-1000
                                            }
                                            catch (Exception ex) {
                                                fc = 0;
                                                fs = 0L;
                                                es = request.events();
                                                for (InputLogEvent e : es) {
                                                    ++fc;
                                                    fs += (long)e.size;
                                                }
                                                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s, %s, %s) is failed with %s: %s", new Object[]{i, request.numberOfActions(), name, url, user, index, ex.getClass().getSimpleName(), ex.getMessage()}));
                                                if (Util.delay(enabled, this.bulkRetryDelay, 200L)) {
                                                    if (debug) {
                                                        ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                                                    }
                                                    break block27;
                                                }
                                                if (debug) {
                                                    ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                                                }
                                                lostCount.addAndGet(fc);
                                                lostSize.addAndGet(fs);
                                                if (debug == false) return;
                                                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [END]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
                                                return;
                                            }
                                        }
                                        catch (Throwable var24_24) {
                                            if (debug == false) throw var24_24;
                                            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                                            throw var24_24;
                                        }
                                    }
                                    break block28;
                                }
                                catch (Throwable var25_25) {
                                    lostCount.addAndGet(fc);
                                    lostSize.addAndGet(fs);
                                    throw var25_25;
                                }
                            }
                            catch (Throwable var26_26) {
                                if (debug == false) throw var26_26;
                                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [END]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
                                throw var26_26;
                            }
lbl-1000:
                            // 1 sources

                            {
                                fc = 0;
                                fs = 0L;
                                if (rsp.errors) ** GOTO lbl-1000
                                if (!debug) break block29;
                            }
                            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                        }
                        lostCount.addAndGet(fc);
                        lostSize.addAndGet(fs);
                        if (debug == false) return;
                        ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [END]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
                        return;
lbl-1000:
                        // 1 sources

                        {
                            irs = rsp.items;
                            fids = new HashSet<String>(irs.size());
                            for (BulkResponse.Item ir : irs) {
                                if (ir.create != null && ir.create.error != null) {
                                    fids.add(ir.create.id);
                                    if (!debug) continue;
                                    ElasticSearchAppender.logSystem(out, Buffer.class, String.format("      [ERROR]: %s", new Object[]{JsonUtil.toString(ir)}));
                                    continue;
                                }
                                if (!debug) continue;
                                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("      [OK]: %s", new Object[]{JsonUtil.toString(ir)}));
                            }
                            r = new BulkRequest(this.bulkCountMax);
                            es = request.events();
                            for (InputLogEvent e : es) {
                                if (!fids.contains(e.id)) continue;
                                r.add(e);
                                ++fc;
                                fs += (long)e.size;
                            }
                            ElasticSearchAppender.logSystem(out, Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s, %s, %s) contains %d failed events of size %d", new Object[]{i, request.numberOfActions(), name, url, user, index, fc, fs}));
                            request = r;
                            if (Util.delay(enabled, this.bulkRetryDelay, 200L)) break block30;
                            if (!debug) break block31;
                        }
                        ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                    }
                    lostCount.addAndGet(fc);
                    lostSize.addAndGet(fs);
                    if (debug == false) return;
                    ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [END]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
                    return;
                }
                if (debug) {
                    ElasticSearchAppender.logSystem(out, Buffer.class, String.format("    [END]: private void Buffer.putEvents.for (int i = 0; (request.numberOfActions=%d > 0) && (i=%d < bulkRetryCount=%d); ++i=%d) {fc=%d, fs=%d}", new Object[]{request.numberOfActions(), i, this.bulkRetryCount, i, fc, fs}));
                }
            }
            ++i;
            ** GOTO lbl8
        }
        lostCount.addAndGet(fc);
        lostSize.addAndGet(fs);
        if (debug == false) return;
        ElasticSearchAppender.logSystem(out, Buffer.class, String.format("  [END]: private void Buffer.putEvents(enabled=%b, client='%s', name='%s', url='%s', user='%s', index='%s', buffer=%d, lostCount=%d, lostSize=%d, out=%b, debug=%b, request.numberOfActions=%d)", new Object[]{enabled.get(), client.toString(), name, url, user, index, buffer, lostCount.get(), lostSize.get(), out, debug, request.numberOfActions()}));
    }
}

