/*
 * Decompiled with CFR 0.152.
 */
package todoapp.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import manifold.collections.extensions.java.lang.Iterable.ManIterableExt;
import manifold.internal.runtime.Bootstrap;

public class ToDo {
    private String title;
    private String id;
    private Status status;

    private ToDo(String title, String id, Status status) {
        this.title = title;
        this.id = id;
        this.status = status;
    }

    public void toggleStatus() {
        this.status = this.isComplete() ? Status.ACTIVE : Status.COMPLETE;
    }

    public boolean isComplete() {
        return this.status == Status.COMPLETE;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static ToDo create(String title) {
        return new ToDo(title, UUID.randomUUID().toString(), Status.ACTIVE);
    }

    static {
        Bootstrap.init();
    }

    public static class DAO {
        private static final List<ToDo> DATA;

        public static void add(ToDo ToDo2) {
            DATA.add(ToDo2);
        }

        public static ToDo find(String id) {
            return (ToDo)ManIterableExt.first(DATA, t -> t.getId().equals(id));
        }

        public static void update(String id, String title) {
            DAO.find(id).setTitle(title);
        }

        public static List<ToDo> ofStatus(String statusString) {
            return statusString == null || statusString.isEmpty() ? DATA : DAO.ofStatus(Status.valueOf(statusString.toUpperCase()));
        }

        public static List<ToDo> ofStatus(Status status) {
            return ManIterableExt.filterToList(DATA, t -> t.getStatus().equals((Object)status));
        }

        public static void remove(String id) {
            DATA.remove(DAO.find(id));
        }

        public static void removeCompleted() {
            DAO.ofStatus(Status.COMPLETE).forEach(t -> DAO.remove(t.getId()));
        }

        public static void toggleStatus(String id) {
            DAO.find(id).toggleStatus();
        }

        public static void toggleAll(boolean complete) {
            DAO.all().forEach(t -> t.setStatus(complete ? Status.COMPLETE : Status.ACTIVE));
        }

        public static List<ToDo> all() {
            return DATA;
        }

        static {
            Bootstrap.init();
            DATA = new ArrayList<ToDo>();
        }
    }

    public static enum Status {
        ACTIVE,
        COMPLETE;


        static {
            Bootstrap.init();
        }
    }
}

