/*
 * Decompiled with CFR 0.152.
 */
package todoapp;

import java.util.List;
import java.util.Optional;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.ManifoldTemplates;
import manifold.templates.runtime.ILayout;
import spark.Request;
import spark.Spark;
import todoapp.model.ToDo;
import todoapp.view.layouts.Main;
import todoapp.view.todo.Display;
import todoapp.view.todo.Edit;

public class App {
    public static void main(String[] args) {
        Spark.exception(Exception.class, (e, req, res) -> e.printStackTrace());
        Spark.staticFiles.location("/public");
        Spark.port((int)9999);
        ManifoldTemplates.setDefaultLayout((String)"todoapp", (ILayout)Main.asLayout());
        Spark.get((String)"/", (req, res) -> App.renderTodos(req));
        Spark.post((String)"/todos", (req, res) -> {
            ToDo.DAO.add(ToDo.create(req.queryParams("todo-title")));
            return App.renderTodos(req);
        });
        Spark.delete((String)"/todos/completed", (req, res) -> {
            ToDo.DAO.removeCompleted();
            return App.renderTodos(req);
        });
        Spark.put((String)"/todos/toggle_status", (req, res) -> {
            ToDo.DAO.toggleAll(req.queryParams("toggle-all") != null);
            return App.renderTodos(req);
        });
        Spark.delete((String)"/todos/:id", (req, res) -> {
            ToDo.DAO.remove(req.params("id"));
            return App.renderTodos(req);
        });
        Spark.put((String)"/todos/:id", (req, res) -> {
            ToDo.DAO.update(req.params("id"), req.queryParams("todo-title"));
            return App.renderTodos(req);
        });
        Spark.put((String)"/todos/:id/toggle_status", (req, res) -> {
            ToDo.DAO.toggleStatus(req.params("id"));
            return App.renderTodos(req);
        });
        Spark.get((String)"/todos/:id/edit", (req, res) -> App.renderEditTodo(req));
    }

    private static String renderEditTodo(Request req) {
        return Edit.withoutLayout().render(ToDo.DAO.find(req.params("id")));
    }

    private static String renderTodos(Request req) {
        boolean allComplete;
        String statusStr = req.queryParams("status");
        List<ToDo> todos = ToDo.DAO.ofStatus(statusStr);
        String filter = Optional.ofNullable(statusStr).orElse("");
        int activeCount = ToDo.DAO.ofStatus(ToDo.Status.ACTIVE).size();
        boolean anyComplete = ToDo.DAO.ofStatus(ToDo.Status.COMPLETE).size() > 0;
        boolean bl = allComplete = ToDo.DAO.all().size() == ToDo.DAO.ofStatus(ToDo.Status.COMPLETE).size();
        if ("true".equals(req.queryParams("ic-request"))) {
            return Display.withoutLayout().render(todos, filter, activeCount, anyComplete, allComplete);
        }
        return Display.render(todos, filter, activeCount, anyComplete, allComplete);
    }

    static {
        Bootstrap.init();
    }
}

