/*
 * Decompiled with CFR 0.152.
 */
package todoapp.view.todo;

import java.io.IOException;
import java.util.List;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.runtime.BaseLayoutOverride;
import manifold.templates.runtime.BaseTemplate;
import manifold.templates.runtime.ILayout;
import todoapp.model.ToDo;

public class Display
extends BaseTemplate {
    private Display() {
    }

    public static String render(List<ToDo> todos, String filter, int activeCount, boolean anyComplete, boolean allComplete) {
        StringBuilder sb = new StringBuilder();
        Display.renderInto(sb, todos, filter, activeCount, anyComplete, allComplete);
        return sb.toString();
    }

    public static LayoutOverride withoutLayout() {
        return Display.withLayout(ILayout.EMPTY);
    }

    public static LayoutOverride withLayout(ILayout layout) {
        Display instance;
        Display display = instance = new Display();
        ((Object)((Object)display)).getClass();
        return display.new LayoutOverride(layout);
    }

    public static void renderInto(Appendable buffer, List<ToDo> todos, String filter, int activeCount, boolean anyComplete, boolean allComplete) {
        Display instance = new Display();
        instance.renderImpl(buffer, null, todos, filter, activeCount, anyComplete, allComplete);
    }

    public void renderImpl(Appendable buffer, ILayout overrideLayout, List<ToDo> todos, String filter, int activeCount, boolean anyComplete, boolean allComplete) {
        try {
            this.beforeRender(buffer, overrideLayout, true);
            long startTime = System.nanoTime();
            int lineStart = Thread.currentThread().getStackTrace()[1].getLineNumber() + 1;
            try {
                buffer.append("\n<header ic-include='{\"status\":\"");
                buffer.append(this.toS(filter));
                buffer.append("\"}'>\n    <h1>todos</h1>\n    <form id=\"todo-form\" ic-post-to=\"/todos\">\n        <input id=\"new-todo\" placeholder=\"What needs to be done?\" name=\"todo-title\" pattern=\".{4,}\" required title=\"> 3 chars\" autofocus>\n    </form>\n</header>\n\n<section id=\"main\" ic-include='{\"status\":\"");
                buffer.append(this.toS(filter));
                buffer.append("\"}'>\n    <input type=\"checkbox\" name=\"toggle-all\" ic-put-to=\"/todos/toggle_status\" id=\"toggle-all\" ");
                buffer.append(this.toS(allComplete ? "checked" : ""));
                buffer.append(">\n    <ul id=\"todo-list\">\n");
                for (ToDo todo : todos) {
                    buffer.append("            <li class=\"#if(" + todo + ".complete)completed#end\">\n                <div class=\"view\">\n                    <input type=\"checkbox\" class=\"toggle\" ic-put-to=\"/todos/");
                    buffer.append(this.toS(todo.getId()));
                    buffer.append("/toggle_status\" ");
                    buffer.append(this.toS(todo.isComplete() ? "checked" : ""));
                    buffer.append(">\n                    <label ic-get-from=\"/todos/");
                    buffer.append(this.toS(todo.getId()));
                    buffer.append("/edit\" ic-target=\"closest li\" ic-trigger-on=\"dblclick\" ic-replace-target=\"true\">");
                    buffer.append(this.toS(todo.getTitle()));
                    buffer.append("</label>\n                    <button class=\"destroy\" ic-delete-from=\"/todos/");
                    buffer.append(this.toS(todo.getId()));
                    buffer.append("\"></button>\n                </div>\n            </li>\n");
                }
                buffer.append("    </ul>\n</section>\n\n<footer>\n    <span id=\"todo-count\">\n        <strong>");
                buffer.append(this.toS(activeCount));
                buffer.append("</strong> items left\n    </span>\n\n    <ul id=\"filters\" ic-push-url=\"true\">\n        <li");
                if (filter.equals("")) {
                    buffer.append(" class=\"selected\" ");
                }
                buffer.append(" ic-get-from=\"/\">All</li>\n        <li");
                if (filter.equals("active")) {
                    buffer.append(" class=\"selected\" ");
                }
                buffer.append(" ic-get-from=\"/?status=active\">Active</li>\n        <li");
                if (filter.equals("complete")) {
                    buffer.append(" class=\"selected\" ");
                }
                buffer.append(" ic-get-from=\"/?status=complete\">Completed</li>\n    </ul>\n\n");
                if (anyComplete) {
                    buffer.append("        <button id=\"clear-completed\" ic-delete-from=\"/todos/completed\" ic-include='{\"status\":\"");
                    buffer.append(this.toS(filter));
                    buffer.append("\"}'>Clear completed</button>\n");
                }
                buffer.append("</footer>");
            }
            catch (RuntimeException e) {
                int[] bbLineNumbers = new int[]{4, 5, 5, 12, 12, 13, 13, 15, 16, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 23, 24, 29, 29, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35, 38, 39, 39, 39, 40, 41};
                this.handleException(e, "Display.html.mtl", lineStart, bbLineNumbers);
            }
            long endTime = System.nanoTime();
            long duration = (endTime - startTime) / 1000000L;
            this.afterRender(buffer, overrideLayout, true, duration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Bootstrap.init();
    }

    public class LayoutOverride
    extends BaseLayoutOverride {
        public LayoutOverride(ILayout override) {
            super(override);
        }

        public String render(List<ToDo> todos, String filter, int activeCount, boolean anyComplete, boolean allComplete) {
            StringBuilder sb = new StringBuilder();
            Display.this.renderImpl(sb, this.getOverride(), todos, filter, activeCount, anyComplete, allComplete);
            return sb.toString();
        }

        public void renderInto(Appendable sb, List<ToDo> todos, String filter, int activeCount, boolean anyComplete, boolean allComplete) {
            Display.this.renderImpl(sb, this.getOverride(), todos, filter, activeCount, anyComplete, allComplete);
        }
    }
}

