/*
 * Decompiled with CFR 0.152.
 */
package manifold.tuple;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.host.RefreshKind;
import manifold.api.service.BaseService;
import manifold.api.type.ClassType;
import manifold.api.type.ContributorKind;
import manifold.api.type.ISourceKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.internal.javac.ITupleTypeProvider;
import manifold.rt.api.util.ManClassUtil;
import manifold.tuple.TupleTypeProvider;
import manifold.tuple.rt.internal.GeneratedTuple;

public class TupleTypeManifold
extends BaseService
implements ITypeManifold {
    private IModule _module;
    private final Map<String, Set<File>> _fqnToEnclosingSourceFile = new ConcurrentHashMap<String, Set<File>>();

    public void init(IModule module) {
        this._module = module;
    }

    public IModule getModule() {
        return this._module;
    }

    public ISourceKind getSourceKind() {
        return ISourceKind.Java;
    }

    public ContributorKind getContributorKind() {
        return ContributorKind.Primary;
    }

    public boolean isTopLevelType(String fqn) {
        return this.isType(fqn);
    }

    public ClassType getClassType(String fqn) {
        return ClassType.JavaClass;
    }

    public List<IFile> findFilesForType(String fqn) {
        return Collections.emptyList();
    }

    public void addEnclosingSourceFile(String fqn, URI sourceFile) {
        Set files = this._fqnToEnclosingSourceFile.computeIfAbsent(fqn, k -> new HashSet());
        files.add(new File(sourceFile));
    }

    public void clear() {
    }

    public boolean isType(String fqn) {
        return fqn.contains('.' + TupleTypeProvider.BASE_NAME);
    }

    public boolean isPackage(String pkg) {
        return !this.getTypeNames(pkg).isEmpty();
    }

    public String getPackage(String fqn) {
        return this.isType(fqn) ? ManClassUtil.getPackage((String)fqn) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String contribute(JavaFileManager.Location location, String fqn, boolean genStubs, String existing, DiagnosticListener<JavaFileObject> errorHandler) {
        Map fieldsMap;
        SrcClass srcClass = (SrcClass)((SrcClass)((SrcClass)((SrcClass)((SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).imports(new Class[]{List.class, ArrayList.class})).modifiers(17L)).superClass(GeneratedTuple.class)).addField((SrcField)new SrcField("_orderedLabels", new SrcType(List.class).addTypeParam(String.class)).modifiers(2L))).addMethod(((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(1L)).addAnnotation(new SrcAnnotationExpression(Override.class))).name("orderedLabels")).returns(new SrcType(List.class).addTypeParam(String.class))).body("return _orderedLabels;"));
        SrcConstructor srcConstructor = (SrcConstructor)new SrcConstructor((AbstractSrcClass)srcClass).modifiers(1L);
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (newLoader != null) {
            Thread.currentThread().setContextClassLoader(newLoader);
        }
        try {
            fieldsMap = ((ITupleTypeProvider)ITupleTypeProvider.INSTANCE.get()).getFields(fqn);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
        if (fieldsMap == null) {
            throw new IllegalStateException("Missing field mapping for tuple: " + fqn);
        }
        SrcStatementBlock body = new SrcStatementBlock().addStatement("List<String> orderedLabels = new ArrayList<>();");
        for (Map.Entry entry : fieldsMap.entrySet()) {
            String name = (String)entry.getKey();
            String type = (String)entry.getValue();
            SrcField field = (SrcField)new SrcField(name, type).modifiers(17L);
            srcClass.addField(field);
            srcConstructor.addParam((SrcParameter)new SrcParameter(name, type).modifiers(16L));
            body.addStatement("this." + name + " = " + name + ";").addStatement("orderedLabels.add( \"" + name + "\" );");
        }
        body.addStatement("_orderedLabels = orderedLabels;");
        srcConstructor.body(body);
        srcClass.addConstructor(srcConstructor);
        return srcClass.render().toString();
    }

    public Collection<String> getAllTypeNames() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TypeName> getTypeNames(String namespace) {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (newLoader != null) {
            Thread.currentThread().setContextClassLoader(newLoader);
        }
        try {
            Collection collection = ((ITupleTypeProvider)ITupleTypeProvider.INSTANCE.get()).getTypes().stream().filter(fqn -> ManClassUtil.getPackage((String)fqn).equals(namespace)).map(fqn -> new TypeName(fqn, this._module, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC)).collect(Collectors.toSet());
            return collection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    public boolean handlesFileExtension(String fileExtension) {
        return false;
    }

    public boolean handlesFile(IFile file) {
        return false;
    }

    public String[] getTypesForFile(IFile file) {
        return new String[0];
    }

    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        return null;
    }
}

