/*
 * Decompiled with CFR 0.152.
 */
package manifold.tuple.rt.api;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import manifold.ext.rt.api.Self;
import manifold.tuple.rt.api.TupleItem;
import manifold.util.ManExceptionUtil;

public interface Tuple
extends Iterable<TupleItem> {
    public List<String> orderedLabels();

    public List<?> orderedValues();

    @Override
    public Iterator<TupleItem> iterator();

    default public Map<String, Object> toMap(boolean recursive) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (TupleItem item : this) {
            String name = item.getName();
            Map<String, Object> value = item.getValue();
            if (recursive && value instanceof Tuple) {
                value = ((Tuple)((Object)value)).toMap(true);
            }
            map.put(name, value);
        }
        return map;
    }

    @Self
    default public Tuple copy() {
        try {
            return (Tuple)this.getClass().getConstructors()[0].newInstance(this.orderedValues().toArray());
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }
}

