/*
 * Decompiled with CFR 0.152.
 */
package manifold.tuple.rt.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import manifold.tuple.rt.api.Tuple;
import manifold.tuple.rt.api.TupleItem;
import manifold.util.ReflectUtil;

public abstract class GeneratedTuple
implements Tuple,
Serializable {
    @Override
    public List<?> orderedValues() {
        return this.orderedLabels().stream().map(f -> {
            try {
                return ReflectUtil.field((Object)this, (String)f).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public int hashCode() {
        return Arrays.hashCode(this.orderedValues().toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!Tuple.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        return this.orderedValues().equals(((Tuple)o).orderedValues()) && this.orderedLabels().equals(((Tuple)o).orderedLabels());
    }

    public String toString() {
        List<String> labels = this.orderedLabels();
        List<?> values = this.orderedValues();
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < labels.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(labels.get(i)).append(": ").append(values.get(i));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Iterator<TupleItem> iterator() {
        return new Iterator<TupleItem>(){
            int _index = 0;
            final List<String> _orderedLabels = GeneratedTuple.this.orderedLabels();
            final List<?> _orderedValues = GeneratedTuple.this.orderedValues();

            @Override
            public boolean hasNext() {
                return this._index < this._orderedValues.size();
            }

            @Override
            public TupleItem next() {
                return new TupleValueImpl(this._orderedLabels.get(this._index), this._orderedValues.get(this._index++));
            }
        };
    }

    private static class TupleValueImpl
    implements TupleItem {
        final String _name;
        final Object _value;

        TupleValueImpl(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Object getValue() {
            return this._value;
        }
    }
}

