/*
 * Decompiled with CFR 0.152.
 */
package manifold.text.extensions.java.lang.CharSequence;

import java.util.Collection;
import manifold.collections.extensions.java.lang.Iterable.ManIterableExt;
import manifold.ext.rt.api.CharPredicate;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.rt.api.util.Pair;

@Extension
public class ManCharSequenceExt {
    public static CharSequence trim(@This CharSequence thiz, CharPredicate predicate) {
        int startIndex = 0;
        int endIndex = thiz.length() - 1;
        boolean startFound = false;
        while (startIndex <= endIndex) {
            int index = startFound ? endIndex : startIndex;
            boolean match = predicate.test(thiz.charAt(index));
            if (!startFound) {
                if (!match) {
                    startFound = true;
                    continue;
                }
                ++startIndex;
                continue;
            }
            if (!match) break;
            --endIndex;
        }
        return thiz.subSequence(startIndex, endIndex + 1);
    }

    public static CharSequence trimStart(@This CharSequence thiz, CharPredicate predicate) {
        for (int index = 0; index < thiz.length(); ++index) {
            if (predicate.test(thiz.charAt(index))) continue;
            return thiz.subSequence(index, thiz.length());
        }
        return "";
    }

    public static CharSequence trimEnd(@This CharSequence thiz, CharPredicate predicate) {
        for (int index = thiz.length() - 1; index >= 0; --index) {
            if (predicate.test(thiz.charAt(index))) continue;
            return thiz.subSequence(0, index + 1);
        }
        return "";
    }

    public static CharSequence trim(@This CharSequence thiz, char ... chars) {
        return ManCharSequenceExt.trim(thiz, it -> {
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != it) continue;
                return true;
            }
            return false;
        });
    }

    public static CharSequence trimStart(@This CharSequence thiz, char ... chars) {
        return ManCharSequenceExt.trimStart(thiz, it -> {
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != it) continue;
                return true;
            }
            return false;
        });
    }

    public static CharSequence trimEnd(@This CharSequence thiz, char ... chars) {
        return ManCharSequenceExt.trimEnd(thiz, it -> {
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != it) continue;
                return true;
            }
            return false;
        });
    }

    public static CharSequence trimStart(@This CharSequence thiz) {
        return ManCharSequenceExt.trimStart(thiz, c -> Character.isWhitespace(c));
    }

    public static CharSequence trimEnd(@This CharSequence thiz) {
        return ManCharSequenceExt.trimEnd(thiz, c -> Character.isWhitespace(c));
    }

    public static CharSequence padStart(@This CharSequence thiz, int length, char padChar) {
        if (length < 0) {
            throw new IllegalArgumentException("Desired length " + length + " is less than zero.");
        }
        if (length <= thiz.length()) {
            return thiz.subSequence(0, thiz.length());
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 1; i <= length - thiz.length(); ++i) {
            sb.append(padChar);
        }
        sb.append(thiz);
        return sb;
    }

    public static CharSequence padEnd(@This CharSequence thiz, int length, char padChar) {
        if (length < 0) {
            throw new IllegalArgumentException("Desired length $length is less than zero.");
        }
        if (length <= thiz.length()) {
            return thiz.subSequence(0, thiz.length());
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(thiz);
        for (int i = 1; i <= length - thiz.length(); ++i) {
            sb.append(padChar);
        }
        return sb;
    }

    public static boolean isNullOrEmpty(@This CharSequence thiz) {
        return thiz == null || thiz.length() == 0;
    }

    public static boolean isEmpty(@This CharSequence thiz) {
        return thiz.length() == 0;
    }

    public static boolean isNotEmpty(@This CharSequence thiz) {
        return thiz.length() > 0;
    }

    public static boolean isBlank(@This CharSequence thiz) {
        return thiz.length() == 0 || ManCharSequenceExt.all(thiz, it -> Character.isWhitespace(it));
    }

    public static boolean all(@This CharSequence thiz, CharPredicate predicate) {
        for (int i = 0; i < thiz.length(); ++i) {
            if (predicate.test(thiz.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrBlank(@This CharSequence thiz) {
        return thiz == null || ManCharSequenceExt.isBlank(thiz);
    }

    public static int lastIndex(@This CharSequence thiz) {
        return thiz.length() - 1;
    }

    public static String substring(@This CharSequence thiz, int startIndex, int endIndex) {
        return thiz.subSequence(startIndex, endIndex).toString();
    }

    public static String substring(@This CharSequence thiz, int startIndex) {
        return thiz.subSequence(startIndex, thiz.length()).toString();
    }

    public static CharSequence removePrefix(@This CharSequence thiz, CharSequence prefix) {
        if (ManCharSequenceExt.startsWith(thiz, prefix)) {
            return thiz.subSequence(prefix.length(), thiz.length());
        }
        return thiz.subSequence(0, thiz.length());
    }

    public static CharSequence removeSuffix(@This CharSequence thiz, CharSequence suffix) {
        if (ManCharSequenceExt.endsWith(thiz, suffix)) {
            return thiz.subSequence(0, thiz.length() - suffix.length());
        }
        return thiz.subSequence(0, thiz.length());
    }

    public static char first(@This CharSequence thiz) {
        return thiz.charAt(0);
    }

    public static char last(@This CharSequence thiz) {
        return thiz.charAt(ManCharSequenceExt.lastIndex(thiz));
    }

    public static boolean startsWith(@This CharSequence thiz, char c) {
        return thiz.length() > 0 && ManCharSequenceExt.first(thiz) == c;
    }

    public static boolean startsWithIgnoreCase(@This CharSequence thiz, char c) {
        return thiz.length() > 0 && (ManCharSequenceExt.first(thiz) == c || Character.toLowerCase(ManCharSequenceExt.first(thiz)) == Character.toLowerCase(c));
    }

    public static boolean endsWith(@This CharSequence thiz, char c) {
        return thiz.length() > 0 && ManCharSequenceExt.last(thiz) == c;
    }

    public static boolean endsWithIgnoreCase(@This CharSequence thiz, char c) {
        return thiz.length() > 0 && (ManCharSequenceExt.last(thiz) == c || Character.toLowerCase(ManCharSequenceExt.last(thiz)) == Character.toLowerCase(c));
    }

    private static boolean regionMatchesImpl(CharSequence thiz, int thisOffset, CharSequence other, int otherOffset, int length, boolean ignoreCase) {
        if (otherOffset < 0 || thisOffset < 0 || thisOffset > thiz.length() - length || otherOffset > other.length() - length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            char otherChar;
            char thisChar = thiz.charAt(thisOffset + index);
            if (thisChar == (otherChar = other.charAt(otherOffset + index)) || ignoreCase && Character.toLowerCase(thisChar) == Character.toLowerCase(otherChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@This CharSequence thiz, CharSequence prefix) {
        if (thiz instanceof String && prefix instanceof String) {
            return ((String)thiz).startsWith((String)prefix);
        }
        return ManCharSequenceExt.regionMatchesImpl(thiz, 0, prefix, 0, prefix.length(), false);
    }

    public static boolean startsWithIgnoreCase(@This CharSequence thiz, CharSequence prefix) {
        return ManCharSequenceExt.regionMatchesImpl(thiz, 0, prefix, 0, prefix.length(), true);
    }

    public static boolean endsWith(@This CharSequence thiz, CharSequence suffix) {
        if (thiz instanceof String && suffix instanceof String) {
            return ((String)thiz).endsWith((String)suffix);
        }
        return ManCharSequenceExt.regionMatchesImpl(thiz, thiz.length() - suffix.length(), suffix, 0, suffix.length(), false);
    }

    public static boolean endsWithIgnoreCase(@This CharSequence thiz, CharSequence suffix) {
        return ManCharSequenceExt.regionMatchesImpl(thiz, thiz.length() - suffix.length(), suffix, 0, suffix.length(), true);
    }

    private static Pair<Integer, Character> findAnyOf(CharSequence thiz, char[] chars, int startIndex, boolean ignoreCase, boolean backward) {
        if (!ignoreCase && chars.length == 1 && thiz instanceof String) {
            char ch = chars[0];
            int index = !backward ? thiz.toString().indexOf(ch, startIndex) : thiz.toString().lastIndexOf(ch, startIndex);
            return index < 0 ? null : new Pair((Object)index, (Object)Character.valueOf(ch));
        }
        if (!backward) {
            int start = Math.max(startIndex, 0);
            int end = ManCharSequenceExt.lastIndex(thiz);
            for (int index = start; index <= end; ++index) {
                char charAtIndex = thiz.charAt(index);
                int matchingCharIndex = ManCharSequenceExt.indexOfFirst(chars, charAtIndex, ignoreCase);
                if (matchingCharIndex < 0) continue;
                return new Pair((Object)index, (Object)Character.valueOf(chars[matchingCharIndex]));
            }
        } else {
            int start;
            for (int index = start = Math.min(startIndex, ManCharSequenceExt.lastIndex(thiz)); index >= 0; --index) {
                char charAtIndex = thiz.charAt(index);
                int matchingCharIndex = ManCharSequenceExt.indexOfFirst(chars, charAtIndex, ignoreCase);
                if (matchingCharIndex < 0) continue;
                return new Pair((Object)index, (Object)Character.valueOf(chars[matchingCharIndex]));
            }
        }
        return null;
    }

    private static int indexOfFirst(char[] chars, char ch, boolean ignoreCase) {
        for (int i = 0; i < chars.length; ++i) {
            char csr = chars[i];
            if (csr != ch && (!ignoreCase || Character.toLowerCase(csr) != Character.toLowerCase(ch))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAny(@This CharSequence thiz, char[] chars) {
        return ManCharSequenceExt.indexOfAny(thiz, chars, 0, false);
    }

    public static int indexOfAny(@This CharSequence thiz, char[] chars, int startIndex) {
        return ManCharSequenceExt.indexOfAny(thiz, chars, startIndex, false);
    }

    public static int indexOfAny(@This CharSequence thiz, char[] chars, int startIndex, boolean ignoreCase) {
        Pair<Integer, Character> result = ManCharSequenceExt.findAnyOf(thiz, chars, startIndex, ignoreCase, false);
        return result == null ? -1 : (Integer)result.getFirst();
    }

    public static int lastIndexOfAny(@This CharSequence thiz, char[] chars) {
        return ManCharSequenceExt.lastIndexOfAny(thiz, chars, ManCharSequenceExt.lastIndex(thiz), false);
    }

    public static int lastIndexOfAny(@This CharSequence thiz, char[] chars, int startIndex) {
        return ManCharSequenceExt.lastIndexOfAny(thiz, chars, startIndex, false);
    }

    public static int lastIndexOfAny(@This CharSequence thiz, char[] chars, int startIndex, boolean ignoreCase) {
        Pair<Integer, Character> result = ManCharSequenceExt.findAnyOf(thiz, chars, startIndex, ignoreCase, true);
        return result == null ? -1 : (Integer)result.getFirst();
    }

    private static int indexOf(CharSequence thiz, CharSequence other, int startIndex, int endIndex, boolean ignoreCase) {
        return ManCharSequenceExt.indexOf(thiz, other, startIndex, endIndex, ignoreCase, false);
    }

    private static int indexOf(CharSequence thiz, CharSequence other, int startIndex, int endIndex, boolean ignoreCase, boolean last) {
        if (!last) {
            int start = Math.max(startIndex, 0);
            int end = Math.min(endIndex, thiz.length());
            if (thiz instanceof String && other instanceof String) {
                for (int index = start; index <= end; ++index) {
                    if (!((String)other).regionMatches(ignoreCase, 0, (String)thiz, index, other.length())) continue;
                    return index;
                }
            } else {
                for (int index = start; index <= end; ++index) {
                    if (!ManCharSequenceExt.regionMatchesImpl(other, 0, thiz, index, other.length(), ignoreCase)) continue;
                    return index;
                }
            }
        } else {
            int start = Math.min(startIndex, ManCharSequenceExt.lastIndex(thiz));
            int end = Math.max(endIndex, 0);
            if (thiz instanceof String && other instanceof String) {
                for (int index = start; index >= 0; --index) {
                    if (!((String)other).regionMatches(ignoreCase, 0, (String)thiz, index, other.length())) continue;
                    return index;
                }
            } else {
                for (int index = start; index >= 0; --index) {
                    if (!ManCharSequenceExt.regionMatchesImpl(other, 0, thiz, index, other.length(), ignoreCase)) continue;
                    return index;
                }
            }
        }
        return -1;
    }

    private static Pair<Integer, String> findAnyOf(CharSequence thiz, Collection<String> strings, int startIndex, boolean ignoreCase, boolean last) {
        if (!ignoreCase && strings.size() == 1) {
            String string = (String)ManIterableExt.single(strings);
            int index = !last ? ManCharSequenceExt.indexOf(thiz, string, startIndex) : ManCharSequenceExt.lastIndexOf(thiz, string, startIndex);
            return index < 0 ? null : new Pair((Object)index, (Object)string);
        }
        if (!last) {
            int start = Math.max(startIndex, 0);
            int end = thiz.length();
            if (thiz instanceof String) {
                int index = start;
                while (index <= end) {
                    int finalIndex;
                    String matchingString;
                    if ((matchingString = (String)ManIterableExt.firstOrNull(strings, arg_0 -> ManCharSequenceExt.lambda$findAnyOf$6(ignoreCase, thiz, finalIndex = index++, arg_0))) == null) continue;
                    return new Pair((Object)index, (Object)matchingString);
                }
            } else {
                int index = start;
                while (index <= end) {
                    int finalIndex;
                    String matchingString;
                    if ((matchingString = (String)ManIterableExt.firstOrNull(strings, arg_0 -> ManCharSequenceExt.lambda$findAnyOf$7(thiz, finalIndex = index++, ignoreCase, arg_0))) == null) continue;
                    return new Pair((Object)index, (Object)matchingString);
                }
            }
        } else {
            int start = Math.min(startIndex, ManCharSequenceExt.lastIndex(thiz));
            if (thiz instanceof String) {
                int index = start;
                while (index >= 0) {
                    int finalIndex;
                    String matchingString;
                    if ((matchingString = (String)ManIterableExt.firstOrNull(strings, arg_0 -> ManCharSequenceExt.lambda$findAnyOf$8(ignoreCase, thiz, finalIndex = index--, arg_0))) == null) continue;
                    return new Pair((Object)index, (Object)matchingString);
                }
            } else {
                int index = start;
                while (index >= 0) {
                    int finalIndex;
                    String matchingString;
                    if ((matchingString = (String)ManIterableExt.firstOrNull(strings, arg_0 -> ManCharSequenceExt.lambda$findAnyOf$9(thiz, finalIndex = index--, ignoreCase, arg_0))) == null) continue;
                    return new Pair((Object)index, (Object)matchingString);
                }
            }
        }
        return null;
    }

    public static Pair<Integer, String> findAnyOf(@This CharSequence thiz, Collection<String> strings) {
        return ManCharSequenceExt.findAnyOf(thiz, strings, 0, false);
    }

    public static Pair<Integer, String> findAnyOf(@This CharSequence thiz, Collection<String> strings, int startIndex) {
        return ManCharSequenceExt.findAnyOf(thiz, strings, startIndex, false);
    }

    public static Pair<Integer, String> findAnyOf(@This CharSequence thiz, Collection<String> strings, int startIndex, boolean ignoreCase) {
        return ManCharSequenceExt.findAnyOf(thiz, strings, startIndex, ignoreCase, false);
    }

    public static Pair<Integer, String> findLastAnyOf(@This CharSequence thiz, Collection<String> strings) {
        return ManCharSequenceExt.findLastAnyOf(thiz, strings, ManCharSequenceExt.lastIndex(thiz), false);
    }

    public static Pair<Integer, String> findLastAnyOf(@This CharSequence thiz, Collection<String> strings, int startIndex) {
        return ManCharSequenceExt.findLastAnyOf(thiz, strings, startIndex, false);
    }

    public static Pair<Integer, String> findLastAnyOf(@This CharSequence thiz, Collection<String> strings, int startIndex, boolean ignoreCase) {
        return ManCharSequenceExt.findAnyOf(thiz, strings, startIndex, ignoreCase, false);
    }

    public static int indexOfAny(@This CharSequence thiz, Collection<String> strings) {
        return ManCharSequenceExt.indexOfAny(thiz, strings, 0, false);
    }

    public static int indexOfAny(@This CharSequence thiz, Collection<String> strings, int startIndex) {
        return ManCharSequenceExt.indexOfAny(thiz, strings, startIndex, false);
    }

    public static int indexOfAny(@This CharSequence thiz, Collection<String> strings, int startIndex, boolean ignoreCase) {
        Pair<Integer, String> result = ManCharSequenceExt.findAnyOf(thiz, strings, startIndex, ignoreCase, false);
        return result == null ? -1 : (Integer)result.getFirst();
    }

    public static int lastIndexOfAny(@This CharSequence thiz, Collection<String> strings) {
        return ManCharSequenceExt.lastIndexOfAny(thiz, strings, ManCharSequenceExt.lastIndex(thiz), false);
    }

    public static int lastIndexOfAny(@This CharSequence thiz, Collection<String> strings, int startIndex) {
        return ManCharSequenceExt.lastIndexOfAny(thiz, strings, startIndex, false);
    }

    public static int lastIndexOfAny(@This CharSequence thiz, Collection<String> strings, int startIndex, boolean ignoreCase) {
        Pair<Integer, String> result = ManCharSequenceExt.findAnyOf(thiz, strings, startIndex, ignoreCase, true);
        return result == null ? -1 : (Integer)result.getFirst();
    }

    public static int indexOf(@This CharSequence thiz, int ch) {
        return ManCharSequenceExt.indexOf(thiz, ch, 0, false);
    }

    public static int indexOf(@This CharSequence thiz, int ch, boolean ignoreCase) {
        return ManCharSequenceExt.indexOf(thiz, ch, 0, ignoreCase);
    }

    public static int indexOf(@This CharSequence thiz, int ch, int startIndex) {
        return ManCharSequenceExt.indexOf(thiz, ch, startIndex, false);
    }

    public static int indexOf(@This CharSequence thiz, int ch, int startIndex, boolean ignoreCase) {
        return ignoreCase || !(thiz instanceof String) ? ManCharSequenceExt.indexOfAny(thiz, new char[]{(char)ch}, startIndex, ignoreCase) : thiz.toString().indexOf(ch, startIndex);
    }

    public static int indexOf(@This CharSequence thiz, String string) {
        return ManCharSequenceExt.indexOf(thiz, string, 0, false);
    }

    public static int indexOf(@This CharSequence thiz, String string, boolean ignoreCase) {
        return ManCharSequenceExt.indexOf(thiz, string, 0, ignoreCase);
    }

    public static int indexOf(@This CharSequence thiz, String string, int startIndex) {
        return ManCharSequenceExt.indexOf(thiz, string, startIndex, false);
    }

    public static int indexOf(@This CharSequence thiz, String string, int startIndex, boolean ignoreCase) {
        return ignoreCase || !(thiz instanceof String) ? ManCharSequenceExt.indexOf(thiz, string, startIndex, thiz.length(), ignoreCase) : thiz.toString().indexOf(string, startIndex);
    }

    public static int lastIndexOf(@This CharSequence thiz, int ch) {
        return ManCharSequenceExt.lastIndexOf(thiz, ch, ManCharSequenceExt.lastIndex(thiz), false);
    }

    public static int lastIndexOf(@This CharSequence thiz, int ch, boolean ignoreCase) {
        return ManCharSequenceExt.lastIndexOf(thiz, ch, ManCharSequenceExt.lastIndex(thiz), ignoreCase);
    }

    public static int lastIndexOf(@This CharSequence thiz, int ch, int startIndex) {
        return ManCharSequenceExt.lastIndexOf(thiz, ch, startIndex, false);
    }

    public static int lastIndexOf(@This CharSequence thiz, int ch, int startIndex, boolean ignoreCase) {
        return ignoreCase || !(thiz instanceof String) ? ManCharSequenceExt.lastIndexOfAny(thiz, new char[]{(char)ch}, startIndex, ignoreCase) : thiz.toString().lastIndexOf(ch, startIndex);
    }

    public static int lastIndexOf(@This CharSequence thiz, String string) {
        return ManCharSequenceExt.lastIndexOf(thiz, string, ManCharSequenceExt.lastIndex(thiz), false);
    }

    public static int lastIndexOf(@This CharSequence thiz, String string, boolean ignoreCase) {
        return ManCharSequenceExt.lastIndexOf(thiz, string, ManCharSequenceExt.lastIndex(thiz), ignoreCase);
    }

    public static int lastIndexOf(@This CharSequence thiz, String string, int startIndex) {
        return ManCharSequenceExt.lastIndexOf(thiz, string, startIndex, false);
    }

    public static int lastIndexOf(@This CharSequence thiz, String string, int startIndex, boolean ignoreCase) {
        return ignoreCase || !(thiz instanceof String) ? ManCharSequenceExt.indexOf(thiz, string, startIndex, 0, ignoreCase, true) : thiz.toString().indexOf(string, startIndex);
    }

    public static boolean contains(@This CharSequence thiz, CharSequence other) {
        return ManCharSequenceExt.contains(thiz, other, false);
    }

    public static boolean contains(@This CharSequence thiz, CharSequence other, boolean ignoreCase) {
        return other instanceof String ? ManCharSequenceExt.indexOf(thiz, (String)other, ignoreCase) >= 0 : ManCharSequenceExt.indexOf(thiz, other, 0, thiz.length(), ignoreCase) >= 0;
    }

    public static boolean contains(@This CharSequence thiz, char ch) {
        return ManCharSequenceExt.contains(thiz, ch, false);
    }

    public static boolean contains(@This CharSequence thiz, char ch, boolean ignoreCase) {
        return ManCharSequenceExt.indexOf(thiz, ch, 0, ignoreCase) >= 0;
    }

    private static /* synthetic */ boolean lambda$findAnyOf$9(CharSequence thiz, int finalIndex, boolean ignoreCase, String it) {
        return ManCharSequenceExt.regionMatchesImpl(it, 0, thiz, finalIndex, it.length(), ignoreCase);
    }

    private static /* synthetic */ boolean lambda$findAnyOf$8(boolean ignoreCase, CharSequence thiz, int finalIndex, String it) {
        return it.regionMatches(ignoreCase, 0, (String)thiz, finalIndex, it.length());
    }

    private static /* synthetic */ boolean lambda$findAnyOf$7(CharSequence thiz, int finalIndex, boolean ignoreCase, String it) {
        return ManCharSequenceExt.regionMatchesImpl(it, 0, thiz, finalIndex, it.length(), ignoreCase);
    }

    private static /* synthetic */ boolean lambda$findAnyOf$6(boolean ignoreCase, CharSequence thiz, int finalIndex, String it) {
        return it.regionMatches(ignoreCase, 0, (String)thiz, finalIndex, it.length());
    }
}

