/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.codegen;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.def.FileFragmentImpl;
import manifold.internal.javac.IIssue;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManEscapeUtil;
import manifold.templates.manifold.TemplateIssue;
import manifold.templates.manifold.TemplateIssueContainer;
import manifold.templates.tokenizer.Token;
import manifold.templates.tokenizer.Tokenizer;

public class TemplateGen {
    private static final String BASE_CLASS_NAME = "BaseTemplate";
    private static final String LAYOUT_INTERFACE = "ILayout";
    private List<TemplateIssue> _issues = new ArrayList<TemplateIssue>();

    public String generateCode(String fullyQualifiedName, String source, IFile file, URI fileUri, String fileName) {
        FileGenerator generator = new FileGenerator(fullyQualifiedName, file, fileUri, fileName, source);
        return generator.getFileContents();
    }

    private void addError(String message, int line) {
        TemplateIssue error = new TemplateIssue(IIssue.Kind.Error, 0, line, 0, message);
        this._issues.add(error);
    }

    public TemplateIssueContainer getIssues() {
        return new TemplateIssueContainer(this._issues);
    }

    class FileGenerator {
        private TemplateStringBuilder _sb = new TemplateStringBuilder();
        private ClassInfo _currClass;
        private List<Token> _tokens;
        private Map<Integer, Directive> _dirMap;

        FileGenerator(String fqn, IFile file, URI fileUri, String fileName, String source) {
            String className = ManClassUtil.getShortClassName((String)fqn);
            String packageName = ManClassUtil.getPackage((String)fqn);
            Tokenizer tokenizer = new Tokenizer();
            this._tokens = tokenizer.tokenize(source);
            List<Directive> dirList = this.getDirectivesList(this._tokens);
            this._dirMap = this.getDirectivesMap(dirList);
            this._currClass = new ClassInfo(dirList.iterator(), fqn, className, file, fileUri, fileName, (Integer)(this._tokens.size() - 1));
            if (fileUri == null) {
                this._currClass.testSource = source;
            }
            this.buildFile(packageName, dirList);
        }

        String getFileContents() {
            return this._sb.toString();
        }

        private void buildFile(String packageName, List<Directive> dirList) {
            this._sb.append("package ").append(packageName + ";\n").newLine("import java.io.IOException;").newLine("import manifold.templates.rt.ManifoldTemplates;").newLine("import manifold.templates.rt.runtime.*;\n");
            this.addImports(dirList);
            this.makeClassContent();
        }

        private boolean containsStringContentOrExpr(List<Token> tokens, Integer start, Integer end) {
            if (end == null) {
                end = tokens.size() - 1;
            }
            for (int i = start.intValue(); i <= end; ++i) {
                Token token = tokens.get(i);
                Token.TokenType tokenType = token.getType();
                if (tokenType != Token.TokenType.CONTENT && tokenType != Token.TokenType.EXPR) continue;
                return true;
            }
            return false;
        }

        private void addRenderImpl() {
            boolean needsToCatchIO;
            this._sb.newLine("    public void renderImpl(Appendable appendable, ILayout overrideLayout").append(this.safeTrailingString(this._currClass.params)).append(") {\n");
            this._sb.append("        renderImpl(appendable, \"\", overrideLayout");
            this.appendArgs().append(");\n");
            this._sb.newLine("    }");
            this._sb.newLine("    public void renderImpl(Appendable appendable, String indentation, ILayout overrideLayout").append(this.safeTrailingString(this._currClass.params)).append(") {");
            this._sb.newLine("      WrapAppendable buffer = new WrapAppendable(appendable, indentation);");
            boolean bl = needsToCatchIO = this._currClass.depth == 0;
            if (!needsToCatchIO) {
                needsToCatchIO = this.containsStringContentOrExpr(this._tokens, this._currClass.startTokenPos - 1, this._currClass.endTokenPos);
            }
            if (needsToCatchIO) {
                this._sb.newLine("        try {");
            }
            if (this._currClass.isLayout) {
                this._sb.newLine("            header(buffer);").newLine("            footer(buffer);");
            } else {
                String isOuterTemplate = String.valueOf(this._currClass.depth == 0);
                this._sb.newLine("            beforeRender(buffer, overrideLayout, ").append(isOuterTemplate).append(");\n");
                this._sb.newLine("            long startTime = System.nanoTime();\n");
                this.makeFuncContent(this._currClass.startTokenPos, this._currClass.endTokenPos);
                this._sb.newLine("            long endTime = System.nanoTime();\n");
                this._sb.newLine("            long duration = (endTime - startTime)/1000000;\n");
                this._sb.newLine("            afterRender(buffer, overrideLayout, ").append(isOuterTemplate).append(", duration);\n");
            }
            if (needsToCatchIO) {
                this._sb.newLine("        } catch (IOException e) {\n").newLine("            throw new RuntimeException(e);\n").newLine("        }\n");
            }
            this._sb.newLine("    }\n\n");
        }

        private void addRender() {
            this._sb.newLine("").newLine("    public static String render(").append(this.safeString(this._currClass.params)).append(") {").newLine("      StringBuilder sb = new StringBuilder();").newLine("      renderInto(sb");
            for (String[] param : this.safeParamsList()) {
                String arg = param.length >= 2 ? param[1] : "err";
                this._sb.append(", ").append(arg);
            }
            this._sb.append(");").newLine("        return sb.toString();").newLine("    }\n");
        }

        private void addRenderInto() {
            this._sb.newLine("    public static void renderInto(Appendable buffer").append(this.safeTrailingString(this._currClass.params)).append(") {\n").newLine("      " + this._currClass.name + " instance = new " + this._currClass.name + "();").newLine("      instance.renderImpl(buffer, null");
            this.appendArgs();
            this._sb.append(");\n").newLine("    }\n\n");
        }

        private void addNestInto() {
            this._sb.newLine("    public static void nestInto(Appendable buffer, String indentation").append(this.safeTrailingString(this._currClass.params)).append(") {\n").newLine("      " + this._currClass.name + " instance = new " + this._currClass.name + "();").newLine("      instance.renderImpl(buffer, indentation, null");
            this.appendArgs();
            this._sb.append(");\n").newLine("    }\n\n");
        }

        private void addWithoutLayout() {
            this._sb.newLine("    public static LayoutOverride withoutLayout() {").newLine("        return withLayout(ILayout.EMPTY);").newLine("    }\n\n");
        }

        private void addWithLayout() {
            this._sb.newLine("    public static LayoutOverride withLayout(ILayout layout) {").newLine("      " + this._currClass.name + " instance = new " + this._currClass.name + "();").newLine("        return instance.new LayoutOverride(layout);").newLine("    }\n\n");
        }

        private void addLayoutOverrideClass() {
            this._sb.newLine("    public class LayoutOverride extends BaseLayoutOverride {").newLine("       public LayoutOverride(ILayout override) {").newLine("         super(override);").newLine("       }\n").newLine("").newLine("    public String render(").append(this.safeString(this._currClass.params)).append(") {").newLine("      StringBuilder sb = new StringBuilder();").newLine("      renderImpl(sb, getOverride()");
            this.appendArgs();
            this._sb.append(");").newLine("        return sb.toString();").newLine("    }\n").newLine("    public void renderInto(Appendable sb").append(this.safeTrailingString(this._currClass.params)).append(") {").newLine("      renderImpl(sb, getOverride()");
            this.appendArgs();
            this._sb.append(");").newLine("    }\n").newLine("    public void nestInto(Appendable sb, String indentation").append(this.safeTrailingString(this._currClass.params)).append(") {").newLine("      renderImpl(sb, indentation, getOverride()");
            this.appendArgs();
            this._sb.append(");").newLine("    }\n").newLine("    }\n");
        }

        private TemplateStringBuilder appendArgs() {
            for (String[] param : this.safeParamsList()) {
                if (param.length <= 1) continue;
                this._sb.append(", ").append(param[1]);
            }
            return this._sb;
        }

        private String safeTrailingString(String string) {
            if (string != null && string.length() > 0) {
                return ", " + string;
            }
            return "";
        }

        private String safeString(String string) {
            if (string != null && string.length() > 0) {
                return string;
            }
            return "";
        }

        private String[][] safeParamsList() {
            String[][] paramsList = this._currClass.paramsList;
            if (paramsList == null) {
                paramsList = new String[0][0];
            }
            return paramsList;
        }

        private void addFileHeader() {
            this._sb.newLine("\n");
            if (this._currClass.depth == 0) {
                if (this._currClass.isLayout) {
                    this._sb.newLine("public class ").append(this._currClass.name).append(" extends ").append(this._currClass.superClass).append(" implements ").append(TemplateGen.LAYOUT_INTERFACE).append(" {");
                } else {
                    this._sb.newLine("public class ").append(this._currClass.name).append(" extends ").append(this._currClass.superClass).append(" {");
                }
            } else {
                this._sb.newLine("public static class ").append(this._currClass.name).append(" extends ").append(this._currClass.superClass).append(" {");
            }
            this._sb.newLine("    private ").append(this._currClass.name).append("(){");
            if (this._currClass.hasLayout) {
                this._sb.newLine("        setLayout(").append(this._currClass.layoutDir.className).append(".asLayout());");
            }
            this._sb.newLine("    }\n");
        }

        private void makeClassContent() {
            this.addFileHeader();
            this.addGetTemplateResourceAsStream();
            this.addRender();
            this.addLayoutOverrideClass();
            this.addWithoutLayout();
            this.addWithLayout();
            this.addRenderInto();
            this.addNestInto();
            this.addRenderImpl();
            if (this._currClass.isLayout) {
                this.addHeaderAndFooter();
            }
            Iterator<ClassInfo> iterator = this._currClass.nestedClasses.values().iterator();
            while (iterator.hasNext()) {
                ClassInfo nested;
                this._currClass = nested = iterator.next();
                this.makeClassContent();
            }
            this._sb.newLine("}\n");
        }

        private void addGetTemplateResourceAsStream() {
            if (this._currClass.isFragment()) {
                this._sb.newLine("    @" + DisableStringLiteralTemplates.class.getTypeName());
                this._sb.newLine("    protected java.io.InputStream getTemplateResourceAsStream() {").newLine("        return new java.io.ByteArrayInputStream(\"" + ManEscapeUtil.escapeForJavaStringLiteral((String)this._currClass.getFragmentText()) + "\".getBytes());").newLine("    }");
            } else {
                this._sb.newLine("    protected java.io.InputStream getTemplateResourceAsStream() {").newLine("        return " + (this._currClass.fileUri == null ? "null" : "getClass().getResourceAsStream(\"" + this.getTemplateFilePath() + "\");")).newLine("    }");
            }
            if (this._currClass.testSource != null) {
                this._sb.newLine("    @" + DisableStringLiteralTemplates.class.getTypeName());
                this._sb.newLine("    protected String getTemplateText() {").newLine("        return \"" + this._currClass.testSource.replace("\"", "\\\\\"").replace("\n", "\\\\n") + "\";").newLine("    }");
            }
        }

        private String getTemplateFilePath() {
            String className = ManClassUtil.getShortClassName((String)this._currClass.fqn);
            String uri = this._currClass.fileUri.toString();
            int nameIndex = uri.lastIndexOf(className);
            String fileExt = uri.substring(nameIndex + className.length());
            return '/' + this._currClass.fqn.replace('.', '/') + fileExt;
        }

        private void addHeaderAndFooter() {
            this._sb.newLine("    public static ").append(TemplateGen.LAYOUT_INTERFACE).append(" asLayout() {").newLine("        return new " + this._currClass.name + "();").newLine("    }\n").newLine("    @Override").newLine("    public void header(Appendable buffer) throws IOException {").newLine("        if (getExplicitLayout() != null) {").newLine("            getExplicitLayout().header(buffer);").newLine("        }");
            assert (this._currClass.depth == 0);
            this.makeFuncContent(this._currClass.startTokenPos, this._currClass.contentPos);
            this._sb.newLine("    }").newLine("    @Override").newLine("    public void footer(Appendable buffer) throws IOException {");
            this.makeFuncContent(this._currClass.contentPos, this._currClass.endTokenPos);
            this._sb.newLine("        if (getExplicitLayout() != null) {").newLine("            getExplicitLayout().footer(buffer);").newLine("    }\n}");
        }

        private List<Directive> getDirectivesList(List<Token> tokens) {
            ArrayList<Directive> dirList = new ArrayList<Directive>();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getType() != Token.TokenType.DIRECTIVE) continue;
                dirList.add(new Directive(i, token, tokens));
            }
            return dirList;
        }

        private Map<Integer, Directive> getDirectivesMap(List<Directive> dirList) {
            HashMap<Integer, Directive> dirMap = new HashMap<Integer, Directive>();
            for (Directive dir : dirList) {
                dirMap.put(dir.tokenPos, dir);
            }
            return dirMap;
        }

        private void addImports(List<Directive> dirList) {
            for (Directive dir : dirList) {
                if (dir._dirType != DirType.IMPORT) continue;
                this._sb.newLine(dir.token.getText().trim() + ";");
            }
        }

        private void makeFuncContent(Integer startPos, Integer endPos) {
            ArrayList<Integer> templateLineNumbers = new ArrayList<Integer>();
            if (endPos == null) {
                endPos = this._tokens.size() - 1;
            }
            this._sb.newLine("            int lineStart = Thread.currentThread().getStackTrace()[1].getLineNumber() + 1;");
            this._sb.newLine("            try {");
            int lastTokenIndex = -1;
            block7: for (int i = startPos.intValue(); i <= endPos; ++i) {
                Token token = this._tokens.get(i);
                switch (token.getType()) {
                    case CONTENT: {
                        int[] loc = this.makeText(lastTokenIndex, this.nextTokenType(i + 1, endPos), token);
                        if (loc == null) break;
                        this._sb.newLine("                buffer.append(getTemplateText(), " + loc[0] + ", " + loc[1] + ");");
                        templateLineNumbers.add(token.getLine());
                        break;
                    }
                    case STMT: {
                        String[] statementList = token.getText().split("\n");
                        for (int j = 0; j < statementList.length; ++j) {
                            String statement = statementList[j].trim();
                            this._sb.append("                ").append(statement).append("\n");
                            templateLineNumbers.add(token.getLine() + j);
                        }
                        break;
                    }
                    case EXPR: {
                        this._sb.newLine("                buffer.append(toS(").append(token.getText()).append("));");
                        templateLineNumbers.add(token.getLine());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    case DIRECTIVE: {
                        Directive dir = this._dirMap.get(i);
                        if (dir._dirType == DirType.SECTION) {
                            ClassInfo classToSkipOver = this._currClass.nestedClasses.get(i + 1);
                            i = classToSkipOver.endTokenPos == null ? endPos.intValue() : classToSkipOver.endTokenPos.intValue();
                            this.addSection(dir);
                            break;
                        }
                        if (dir._dirType == DirType.END_SECTION) break block7;
                        if (dir._dirType == DirType.INCLUDE) {
                            this.addInclude(dir);
                            break;
                        }
                        if (dir._dirType == DirType.NEST) {
                            this.addNest(dir, i);
                            break;
                        }
                        if (dir._dirType != DirType.CONTENT) break;
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                lastTokenIndex = i;
            }
            String nums = templateLineNumbers.toString().substring(1, templateLineNumbers.toString().length() - 1);
            this._sb.newLine("            } catch (RuntimeException e) {");
            this._sb.newLine("                int[] templateLineNumbers = new int[]{").append(nums).append("};");
            this._sb.newLine("                handleException(e, \"").append(this._currClass.fileName).append("\", lineStart, templateLineNumbers);\n            }");
        }

        private Token.TokenType nextTokenType(int index, Integer endPos) {
            if (index <= endPos) {
                return this._tokens.get(index).getType();
            }
            return null;
        }

        private int[] makeText(int prevTokenIndex, Token.TokenType nextTokenType, Token token) {
            Token.TokenType prevTokenType;
            int[] loc = null;
            String text = token.getText();
            Token prevToken = prevTokenIndex < 0 ? null : this._tokens.get(prevTokenIndex);
            Token.TokenType tokenType = prevTokenType = prevToken == null ? null : prevToken.getType();
            if (text != null && text.length() > 0) {
                int length;
                int offset = token.getOffset();
                if (prevTokenType != Token.TokenType.CONTENT && prevTokenType != Token.TokenType.EXPR && (prevTokenType != Token.TokenType.DIRECTIVE || this._dirMap.get((Object)Integer.valueOf((int)prevTokenIndex))._dirType != DirType.NEST)) {
                    if (text.charAt(0) == '\n') {
                        ++offset;
                    } else if (text.length() > 1 && text.charAt(0) == '\r' && text.charAt(1) == '\n') {
                        offset += 2;
                    }
                }
                if ((length = this.removeTrailingIndentation(text, nextTokenType)) > 0 && (length -= offset - token.getOffset()) > 0) {
                    loc = new int[]{offset, offset + length};
                }
            }
            return loc;
        }

        private int removeTrailingIndentation(String text, Token.TokenType nextTokenType) {
            int length = text.length();
            if (text.length() > 0 && nextTokenType != Token.TokenType.CONTENT && nextTokenType != Token.TokenType.EXPR_ANGLE_BEGIN && nextTokenType != Token.TokenType.EXPR_BRACE_BEGIN) {
                if (this.isSpaces(text)) {
                    length = 0;
                } else {
                    int iEol = text.lastIndexOf(10);
                    if (iEol >= 0) {
                        for (int i = text.length() - 1; i >= iEol; --i) {
                            char c = text.charAt(i);
                            if (c == ' ' || c == '\t') continue;
                            length = i + 1;
                            break;
                        }
                    }
                }
            }
            return length;
        }

        private boolean isSpaces(String text) {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return false;
            }
            return true;
        }

        private void addInclude(Directive dir) {
            assert (dir._dirType == DirType.INCLUDE);
            if (dir.conditional != null) {
                this._sb.newLine("            if(").append(dir.conditional).append("){");
            }
            this._sb.newLine("            ").append(dir.className).append(".withoutLayout().renderInto(buffer").append(this.safeTrailingString(dir.params)).append(");");
            if (dir.conditional != null) {
                this._sb.newLine("            ").append("}");
            }
        }

        private void addNest(Directive dir, int index) {
            assert (dir._dirType == DirType.NEST);
            String indentation = this.getIndentation(index - 2);
            if (dir.conditional != null) {
                this._sb.newLine("            if(").append(dir.conditional).append("){");
            }
            this._sb.newLine("            ").append(dir.className).append(".withoutLayout().nestInto(buffer, \"" + indentation + "\"").append(this.safeTrailingString(dir.params)).append(");");
            if (dir.conditional != null) {
                this._sb.newLine("            ").append("}");
            }
        }

        private String getIndentation(int index) {
            if (index < 0) {
                return "";
            }
            Token token = this._tokens.get(index);
            if (token.getType() == Token.TokenType.CONTENT) {
                char c;
                StringBuilder indent = new StringBuilder();
                String text = token.getText();
                int len = text.length();
                for (int i = 0; i < len && ((c = text.charAt(len - i - 1)) == ' ' || c == '\t'); ++i) {
                    indent.insert(0, c);
                }
                return indent.toString();
            }
            return "";
        }

        private void addSection(Directive dir) {
            assert (dir._dirType == DirType.SECTION);
            if (dir.params != null) {
                String paramsWithoutTypes = dir.makeParamsStringWithoutTypes(dir.paramsList);
                this._sb.newLine("            ").append(dir.className).append(".renderInto(buffer, ").append(paramsWithoutTypes).append(");");
            } else {
                this._sb.newLine("            ").append(dir.className).append(".renderInto(buffer);");
            }
        }

        private class TemplateStringBuilder {
            private final String INDENT = "    ";
            private StringBuilder sb = new StringBuilder();

            private TemplateStringBuilder() {
            }

            TemplateStringBuilder newLine(String content) {
                this.sb.append("\n");
                for (int i = 0; i < ((FileGenerator)FileGenerator.this)._currClass.depth; ++i) {
                    this.sb.append("    ");
                }
                this.sb.append(content);
                return this;
            }

            TemplateStringBuilder append(String content) {
                this.sb.append(content);
                return this;
            }

            public String toString() {
                return this.sb.toString();
            }
        }
    }

    class Directive {
        int tokenPos;
        Token token;
        DirType _dirType;
        String className;
        String params;
        String[][] paramsList;
        String conditional;

        Directive(int tokenPos, Token token, List<Token> tokens) {
            assert (token.getType() == Token.TokenType.DIRECTIVE);
            this.tokenPos = tokenPos;
            this.token = token;
            this.identifyType();
            this.fillVars(tokens);
        }

        private void identifyType() {
            String text = this.token.getText().trim();
            Optional<DirType> dirType = Arrays.stream(DirType.values()).filter(dt -> text.startsWith(dt.keyword())).findFirst();
            this._dirType = dirType.orElse(DirType.ERRANT);
            if (this._dirType == DirType.ERRANT) {
                TemplateGen.this.addError("Unsupported Directive Type", this.token.getLine());
            }
        }

        private void fillVars(List<Token> tokens) {
            String text = this.token.getText();
            text = text.trim();
            switch (this._dirType) {
                case IMPORT: {
                    break;
                }
                case EXTENDS: {
                    this.className = text.substring(DirType.EXTENDS.keyword().length()).trim();
                    break;
                }
                case PARAMS: {
                    String content = text.substring(DirType.PARAMS.keyword().length()).trim();
                    if (content.length() <= 1) break;
                    this.params = content.substring(1, content.length() - 1);
                    this.paramsList = this.splitParamsList(this.params);
                    break;
                }
                case NEST: 
                case INCLUDE: {
                    this.fillIncludeVars(this._dirType);
                    break;
                }
                case SECTION: {
                    String[] temp = text.substring(DirType.SECTION.keyword().length()).trim().split("\\(", 2);
                    this.className = temp[0].trim();
                    if (temp.length != 2 || temp[1].equals(")") || temp[1].trim().isEmpty()) break;
                    this.params = temp[1].substring(0, temp[1].length() - 1).trim();
                    this.paramsList = this.splitParamsList(this.params);
                    this.findParamTypes(this.paramsList, this.tokenPos, tokens);
                    this.params = this.makeParamsString(this.paramsList);
                    break;
                }
                case END_SECTION: {
                    break;
                }
                case CONTENT: {
                    break;
                }
                case LAYOUT: {
                    this.className = text.substring(DirType.LAYOUT.keyword().length()).trim();
                    break;
                }
            }
        }

        private void fillIncludeVars(DirType dirType) {
            String text = this.token.getText();
            text = text.trim();
            String content = text.substring(dirType == DirType.INCLUDE ? DirType.INCLUDE.keyword().length() : DirType.NEST.keyword().length()).trim();
            for (int index = 0; index < content.length(); ++index) {
                if (content.charAt(index) == '(') {
                    this.className = content.substring(0, index).trim();
                    this.params = null;
                    if (content.length() > index + 1 && content.indexOf(41, index + 1) >= 0) {
                        this.params = content.substring(index + 1, content.indexOf(41));
                        this.fillConditional(content.substring(content.indexOf(41) + 1).trim());
                    } else {
                        TemplateGen.this.addError("')' expected", this.token.getLine());
                    }
                    return;
                }
                if (index >= content.length() - 2 || content.charAt(index) != ' ' || content.charAt(index + 1) != 'i' || content.charAt(index + 2) != 'f') continue;
                this.className = content.substring(0, index).trim();
                this.params = null;
                if (content.length() > index + 1) {
                    this.fillConditional(content.substring(index + 1).trim());
                } else {
                    TemplateGen.this.addError("'if' condition expected", this.token.getLine());
                }
                return;
            }
            this.className = content;
        }

        private void fillConditional(String conditional) {
            if (conditional.length() < 2) {
                return;
            }
            String conditionalWithoutIf = conditional.substring(2);
            if (conditionalWithoutIf.length() > 0 && conditionalWithoutIf.charAt(0) == '(') {
                if (conditionalWithoutIf.length() > 2) {
                    this.conditional = conditionalWithoutIf.substring(1, conditionalWithoutIf.length() - 1);
                } else {
                    TemplateGen.this.addError("Expecting a condition expression", this.token.getLine());
                }
            } else {
                this.conditional = conditionalWithoutIf;
            }
        }

        private String[][] splitParamsList(String params) {
            params = params.trim();
            params = params.replaceAll(" ,", ",").replace(", ", ",");
            String[] parameters = params.split(",");
            String[][] paramsList = new String[parameters.length][2];
            for (int i = 0; i < parameters.length; ++i) {
                paramsList[i] = parameters[i].split(" ", 2);
            }
            return paramsList;
        }

        private String makeParamsString(String[][] paramsList) {
            StringBuilder params = new StringBuilder().append(paramsList[0][0]).append(" ").append(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][0]).append(" ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private void findParamTypes(String[][] params, int tokenPos, List<Token> tokens) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].length != 1) continue;
                String name = params[i][0];
                params[i] = new String[2];
                params[i][0] = this.inferSingleArgumentType(name, tokenPos, tokens);
                params[i][1] = name;
            }
        }

        private String makeParamsStringWithoutTypes(String[][] paramsList) {
            StringBuilder params = new StringBuilder(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private String inferSingleArgumentType(String name, int tokenPos, List<Token> tokens) {
            String pattern = "([a-zA-Z_$][a-zA-Z_$0-9]* " + name + ")|(\".*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*\")|('.*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*')";
            Pattern argumentRegex = Pattern.compile(pattern);
            for (int i = tokenPos - 1; i >= 0; --i) {
                String[][] outerClassParameters;
                Token currentToken = tokens.get(i);
                if (currentToken.getType() == Token.TokenType.STMT) {
                    String text = currentToken.getText();
                    text = text.trim();
                    Matcher argumentMatcher = argumentRegex.matcher(text);
                    String toReturn = null;
                    while (argumentMatcher.find()) {
                        if (argumentMatcher.group(1) == null) continue;
                        toReturn = argumentMatcher.group(1);
                    }
                    if (toReturn == null) continue;
                    return toReturn.split(" ")[0];
                }
                if (currentToken.getType() != Token.TokenType.DIRECTIVE) continue;
                Directive cur = new Directive(i, currentToken, tokens);
                if (cur._dirType != DirType.PARAMS) continue;
                for (String[] currentParams : outerClassParameters = cur.paramsList) {
                    String parameter = currentParams[1];
                    if (!name.equals(parameter)) continue;
                    return currentParams[0];
                }
            }
            TemplateGen.this.addError("Type for argument can not be inferred: " + name, this.token.getLine());
            return "";
        }
    }

    protected static enum DirType {
        IMPORT("import"),
        EXTENDS("extends"),
        PARAMS("params"),
        INCLUDE("include"),
        NEST("nest"),
        SECTION("section"),
        END_SECTION("end"),
        CONTENT("content"),
        LAYOUT("layout"),
        ERRANT("#errant");

        private String _keyword;

        private DirType(String keyword) {
            this._keyword = keyword;
        }

        public String keyword() {
            return this._keyword;
        }
    }

    class ClassInfo {
        final String fqn;
        private final ClassInfo parent;
        Map<Integer, ClassInfo> nestedClasses = new HashMap<Integer, ClassInfo>();
        String params = null;
        String[][] paramsList = null;
        String name;
        URI fileUri;
        String fileName;
        String superClass = "BaseTemplate";
        int startTokenPos;
        Integer endTokenPos;
        int depth;
        boolean isLayout = false;
        boolean hasLayout = false;
        Directive layoutDir;
        int contentPos;
        String testSource;
        private IFile _file;

        private ClassInfo(Iterator<Directive> dirIterator, String fqn, String name, IFile file, URI fileUri, String fileName, Integer endTokenPos) {
            this.parent = null;
            this.fqn = fqn;
            this.name = name;
            this.fileUri = fileUri;
            this.fileName = fileName;
            this.startTokenPos = 0;
            this.endTokenPos = endTokenPos;
            this.depth = 0;
            this._file = file;
            this.fillClassInfo(dirIterator);
        }

        ClassInfo(Iterator<Directive> dirIterator, ClassInfo parent, String name, String params, String[][] paramList, int startTokenPos, int depth, String superClass) {
            this.parent = parent;
            this.fqn = parent.fqn;
            this.name = name;
            this.fileUri = parent.fileUri;
            this.fileName = parent.fileName;
            this.params = params;
            this.paramsList = paramList;
            this.startTokenPos = startTokenPos;
            this.depth = depth;
            this.superClass = superClass;
            this.fillClassInfo(dirIterator);
        }

        /*
         * Enabled aggressive block sorting
         */
        void fillClassInfo(Iterator<Directive> dirIterator) {
            boolean endSec = false;
            while (dirIterator.hasNext()) {
                Directive dir = dirIterator.next();
                switch (dir._dirType) {
                    case IMPORT: {
                        break;
                    }
                    case NEST: 
                    case INCLUDE: {
                        break;
                    }
                    case EXTENDS: {
                        if (this.depth == 0) {
                            if (this.superClass.equals(TemplateGen.BASE_CLASS_NAME)) {
                                this.superClass = dir.className;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Extends Directive: class cannot extend 2 classes", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Extends Directive: class cannot extend within section", dir.token.getLine());
                        break;
                    }
                    case PARAMS: {
                        if (this.depth == 0) {
                            if (this.params == null) {
                                this.params = dir.params;
                                this.paramsList = dir.paramsList;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Params Directive: class cannot have 2 params directives", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Params Directive: class cannot have param directive within section", dir.token.getLine());
                        break;
                    }
                    case SECTION: {
                        this.addNestedClass(new ClassInfo(dirIterator, this, dir.className, dir.params, dir.paramsList, dir.tokenPos + 1, this.depth + 1, this.superClass));
                        break;
                    }
                    case END_SECTION: {
                        if (this.endTokenPos == null) {
                            this.endTokenPos = dir.tokenPos;
                            return;
                        } else {
                            TemplateGen.this.addError("Invalid End Section Directive: section declaration does not exist", dir.token.getLine());
                        }
                        return;
                    }
                    case CONTENT: {
                        if (this.isLayout) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot have two layout instantiations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot instantiate layout within section", dir.token.getLine());
                            break;
                        }
                        this.isLayout = true;
                        this.contentPos = dir.tokenPos;
                        break;
                    }
                    case LAYOUT: {
                        if (this.hasLayout) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot have two layout declarations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot declare layout within section", dir.token.getLine());
                            break;
                        }
                        this.hasLayout = true;
                        this.layoutDir = dir;
                    }
                }
            }
            if (endSec) return;
            if (this.depth == 0) {
                if ($assertionsDisabled) return;
                if (this.startTokenPos == 0) return;
                throw new AssertionError();
            }
            TemplateGen.this.addError("Reached end of file before parsing section: " + this.name, 0);
        }

        void addNestedClass(ClassInfo nestedClass) {
            this.nestedClasses.put(nestedClass.startTokenPos, nestedClass);
        }

        public boolean isFragment() {
            return this._file instanceof IFileFragment;
        }

        public String getFragmentText() {
            return ((FileFragmentImpl)this._file).getContent();
        }
    }
}

