/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.manifold;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IManifoldHost;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.rt.api.util.StreamUtil;
import manifold.templates.codegen.TemplateGen;
import manifold.templates.manifold.TemplateIssueContainer;

class TemplateModel
extends AbstractSingleFileModel {
    private String _source;
    private TemplateIssueContainer _issues;

    TemplateModel(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.init();
    }

    private void init() {
        IFile file = this.getFile();
        if (!file.exists()) {
            return;
        }
        try {
            String templateSource = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
            templateSource = templateSource.replace("\r\n", "\n");
            TemplateGen generator = new TemplateGen();
            this._source = generator.generateCode(this.getFqn(), templateSource, file, file.toURI(), file.getName());
            this._issues = generator.getIssues();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    String getSource() {
        return this._source;
    }

    void report(DiagnosticListener errorHandler) {
        if (this._issues.isEmpty() || errorHandler == null) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : this._issues.getIssues()) {
            int offset = issue.getStartOffset();
            if (this.getFile() instanceof IFileFragment) {
                offset += ((IFileFragment)this.getFile()).getOffset();
            }
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report(new JavacDiagnostic((JavaFileObject)file, kind, (long)offset, (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
        }
    }
}

