/*
 * Decompiled with CFR 0.152.
 */
package manifold.strings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;

public class StringLiteralTemplateParser {
    private final String _stringValue;
    private final boolean _simpleExprDisabled;
    private final IntPredicate _escapeMatcher;
    private int _index;

    public static List<Expr> parse(IntPredicate $escapeMatcher, boolean simpleExprDisabled, String stringValue) {
        if (StringLiteralTemplateParser.isFilterFromTemplateParsing(stringValue)) {
            return Collections.emptyList();
        }
        return new StringLiteralTemplateParser($escapeMatcher, simpleExprDisabled, stringValue).parse();
    }

    private static boolean isFilterFromTemplateParsing(String stringValue) {
        return stringValue.trim().startsWith("[>") || stringValue.startsWith("\"[>") || stringValue.startsWith("\"\"\"") && stringValue.contains("[>");
    }

    private StringLiteralTemplateParser(IntPredicate $escapeMatcher, boolean simpleExprDisabled, String stringValue) {
        this._stringValue = stringValue;
        this._simpleExprDisabled = simpleExprDisabled;
        this._escapeMatcher = $escapeMatcher;
    }

    private boolean isSimpleExprDisabled() {
        return this._simpleExprDisabled;
    }

    private List<Expr> parse() {
        ArrayList<Expr> comps = new ArrayList<Expr>();
        StringBuilder contentExpr = new StringBuilder();
        int length = this._stringValue.length();
        int offset = 0;
        this._index = 0;
        while (this._index < length) {
            Expr expr;
            char c = this._stringValue.charAt(this._index);
            if (c == '$' && !this._escapeMatcher.test(this._index) && (expr = this.parseExpr()) != null) {
                if (contentExpr.length() > 0) {
                    comps.add(new Expr(contentExpr.toString(), offset, ExprKind.Verbatim));
                    contentExpr = new StringBuilder();
                    offset = this._index + 1;
                }
                comps.add(expr);
            } else {
                contentExpr.append(c);
            }
            ++this._index;
        }
        if (!comps.isEmpty() && contentExpr.length() > 0) {
            comps.add(new Expr(contentExpr.toString(), offset, ExprKind.Verbatim));
        }
        return comps;
    }

    private Expr parseExpr() {
        if (this._index + 1 == this._stringValue.length()) {
            return null;
        }
        return this._stringValue.charAt(this._index + 1) == '{' ? this.parseBraceExpr() : this.parseSimpleExpr();
    }

    private Expr parseBraceExpr() {
        int index;
        int length = this._stringValue.length();
        StringBuilder expr = new StringBuilder();
        int offset = index = this._index + 2;
        while (index < length) {
            char c = this._stringValue.charAt(index);
            if (c == '}') {
                if (expr.length() <= 0) break;
                this._index = index;
                return new Expr(expr.toString(), offset, ExprKind.Complex);
            }
            expr.append(c);
            ++index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expr parseSimpleExpr() {
        int index;
        if (this.isSimpleExprDisabled()) {
            return null;
        }
        int length = this._stringValue.length();
        int offset = index = this._index + 1;
        StringBuilder expr = new StringBuilder();
        while (index < length) {
            char c = this._stringValue.charAt(index);
            if (expr.length() == 0) {
                if (c == '$') return null;
                if (!Character.isJavaIdentifierStart(c)) return null;
                expr.append(c);
            } else {
                if (c == '$' || !Character.isJavaIdentifierPart(c)) break;
                expr.append(c);
            }
            this._index = index++;
        }
        if (expr.length() <= 0) return null;
        Expr expr2 = new Expr(expr.toString(), offset, ExprKind.Identifier);
        return expr2;
    }

    public static enum ExprKind {
        Verbatim,
        Identifier,
        Complex;

    }

    public class Expr {
        private String _expr;
        private ExprKind _kind;
        private int _offset;

        Expr(String expr, int offset, ExprKind kind) {
            this._expr = expr;
            this._offset = offset;
            this._kind = kind;
        }

        public String getExpr() {
            return this._expr;
        }

        public int getOffset() {
            return this._offset;
        }

        public boolean isVerbatim() {
            return this._kind == ExprKind.Verbatim;
        }

        public boolean isIdentifier() {
            return this._kind == ExprKind.Identifier;
        }
    }
}

