/*
 * Decompiled with CFR 0.152.
 */
package manifold.strings;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.IntPredicate;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import manifold.api.type.ICompilerComponent;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.util.ServiceUtil;
import manifold.rt.api.util.Stack;
import manifold.strings.ManDiagnosticHandler;
import manifold.strings.NameReplacer;
import manifold.strings.StringLiteralTemplateParser;
import manifold.strings.api.ITemplateProcessorGate;

public class StringLiteralTemplateProcessor
extends TreeTranslator
implements ICompilerComponent,
TaskListener {
    private TypeProcessor _tp;
    private BasicJavacTask _javacTask;
    private Stack<Boolean> _disabled;
    private ManDiagnosticHandler _manDiagnosticHandler;
    private SortedSet<ITemplateProcessorGate> _processorGates;

    public void init(BasicJavacTask javacTask, TypeProcessor typeProcessor) {
        this._tp = typeProcessor;
        this._javacTask = javacTask;
        this._disabled = new Stack();
        this._disabled.push((Object)false);
        javacTask.addTaskListener(this);
        this.loadTemplateProcessorGates();
    }

    private void loadTemplateProcessorGates() {
        this._processorGates = new TreeSet<ITemplateProcessorGate>(Comparator.comparing(c -> c.getClass().getTypeName()));
        ServiceUtil.loadRegisteredServices(this._processorGates, ITemplateProcessorGate.class, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.PARSE) {
            return;
        }
        this._manDiagnosticHandler = new ManDiagnosticHandler(this._javacTask.getContext());
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.PARSE) {
            return;
        }
        try {
            Log.instance(this._javacTask.getContext()).popDiagnosticHandler(this._manDiagnosticHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
            JCTree.JCClassDecl classDecl;
            if (!(tree instanceof JCTree.JCClassDecl) || this.isTypeExcluded(classDecl = (JCTree.JCClassDecl)tree, e.getCompilationUnit())) continue;
            classDecl.accept(this);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl classDef) {
        this.process(classDef.getModifiers(), () -> super.visitClassDef(classDef));
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl methodDecl) {
        this.process(methodDecl.getModifiers(), () -> super.visitMethodDef(methodDecl));
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl varDecl) {
        this.process(varDecl.getModifiers(), () -> super.visitVarDef(varDecl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(JCTree.JCModifiers modifiers, Runnable processor) {
        Boolean disable = this.getDisableAnnotationValue(modifiers);
        if (disable != null) {
            this.pushDisabled(disable);
        }
        try {
            processor.run();
        }
        finally {
            if (disable != null) {
                this.popDisabled(disable);
            }
        }
    }

    private boolean isTypeExcluded(JCTree.JCClassDecl classDef, CompilationUnitTree compilationUnit) {
        if (this._processorGates.isEmpty()) {
            return false;
        }
        ExpressionTree pkgName = compilationUnit.getPackageName();
        if (pkgName == null) {
            return false;
        }
        String simpleName = classDef.name.toString();
        String fqn = pkgName.toString() + '.' + simpleName;
        return this._processorGates.stream().anyMatch(gate -> gate.exclude(fqn));
    }

    private Boolean getDisableAnnotationValue(JCTree.JCModifiers modifiers) {
        Boolean disable = null;
        for (JCTree.JCAnnotation anno : modifiers.getAnnotations()) {
            if (!anno.annotationType.toString().contains(DisableStringLiteralTemplates.class.getSimpleName())) continue;
            try {
                Object value;
                java.util.List args = anno.getArguments();
                if (((List)args).isEmpty()) {
                    disable = true;
                    continue;
                }
                JCTree.JCExpression argExpr = (JCTree.JCExpression)((List)args).get(0);
                if (argExpr instanceof JCTree.JCLiteral && (value = ((JCTree.JCLiteral)argExpr).getValue()) instanceof Boolean) {
                    disable = (boolean)((Boolean)value);
                    continue;
                }
                IDynamicJdk.instance().logError(Log.instance(this._javacTask.getContext()), argExpr.pos(), "proc.messager", new Object[]{"Only boolean literal values 'true' and 'false' allowed here"});
                disable = true;
            }
            catch (Exception e) {
                disable = true;
            }
        }
        return disable;
    }

    private boolean isDisabled() {
        return (Boolean)this._disabled.peek();
    }

    private void pushDisabled(boolean disabled) {
        this._disabled.push((Object)disabled);
    }

    private void popDisabled(boolean disabled) {
        if (disabled != (Boolean)this._disabled.pop()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jcAnno) {
        this.pushDisabled(true);
        try {
            super.visitAnnotation(jcAnno);
        }
        finally {
            this.popDisabled(true);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jcLiteral) {
        super.visitLiteral(jcLiteral);
        Object value = jcLiteral.getValue();
        if (!(value instanceof String)) {
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        TreeMaker maker = TreeMaker.instance(this._javacTask.getContext());
        String stringValue = (String)value;
        java.util.List<JCTree.JCExpression> exprs = this.parse(stringValue, jcLiteral.getPreferredPosition());
        JCTree concat = null;
        while (!exprs.isEmpty()) {
            if (concat == null) {
                concat = maker.Binary(JCTree.Tag.PLUS, exprs.remove(0), exprs.remove(0));
                continue;
            }
            concat = maker.Binary(JCTree.Tag.PLUS, (JCTree.JCExpression)concat, exprs.remove(0));
        }
        this.result = concat == null ? this.result : concat;
    }

    public java.util.List<JCTree.JCExpression> parse(String stringValue, int literalOffset) {
        java.util.List<StringLiteralTemplateParser.Expr> comps = StringLiteralTemplateParser.parse(new EscapeMatcher(this._manDiagnosticHandler, literalOffset + 1), stringValue);
        if (comps.isEmpty()) {
            return Collections.emptyList();
        }
        TreeMaker maker = TreeMaker.instance(this._javacTask.getContext());
        Names names = Names.instance(this._javacTask.getContext());
        ArrayList<JCTree.JCExpression> exprs = new ArrayList<JCTree.JCExpression>();
        StringLiteralTemplateParser.Expr prev = null;
        for (StringLiteralTemplateParser.Expr comp : comps) {
            JCTree.JCExpression expr;
            if (comp.isVerbatim()) {
                expr = maker.Literal(comp.getExpr());
            } else {
                if (prev != null && !prev.isVerbatim()) {
                    exprs.add(maker.Literal(""));
                }
                int exprPos = literalOffset + 1 + comp.getOffset();
                if (comp.isIdentifier()) {
                    JCTree.JCIdent ident = maker.Ident(names.fromString(comp.getExpr()));
                    ident.pos = exprPos;
                    expr = ident;
                } else {
                    DiagnosticCollector<JavaFileObject> errorHandler = new DiagnosticCollector<JavaFileObject>();
                    expr = this._tp.getHost().getJavaParser().parseExpr(comp.getExpr(), errorHandler);
                    if (this.transferParseErrors(literalOffset, comp, expr, errorHandler)) {
                        return Collections.emptyList();
                    }
                    this.replaceNames(expr, exprPos);
                }
            }
            prev = comp;
            exprs.add(expr);
        }
        if (exprs.size() == 1) {
            exprs.add(0, maker.Literal(""));
        }
        return exprs;
    }

    private boolean transferParseErrors(int literalOffset, StringLiteralTemplateParser.Expr comp, JCTree.JCExpression expr, DiagnosticCollector<JavaFileObject> errorHandler) {
        if (expr == null || errorHandler.getDiagnostics().stream().anyMatch(e -> e.getKind() == Diagnostic.Kind.ERROR)) {
            for (Diagnostic<JavaFileObject> diag : errorHandler.getDiagnostics()) {
                if (diag.getKind() != Diagnostic.Kind.ERROR) continue;
                JCDiagnostic jcDiag = ((ClientCodeWrapper.DiagnosticSourceUnwrapper)diag).d;
                String code = this.debaseMsgCode(diag);
                IDynamicJdk.instance().logError(Log.instance(this._javacTask.getContext()), (JCDiagnostic.DiagnosticPosition)new JCDiagnostic.SimpleDiagnosticPosition(literalOffset + 1 + comp.getOffset()), code, jcDiag.getArgs());
            }
            return true;
        }
        return false;
    }

    private String debaseMsgCode(Diagnostic<? extends JavaFileObject> diag) {
        String code = diag.getCode();
        if (code != null && code.startsWith("compiler.err")) {
            code = code.substring("compiler.err".length() + 1);
        }
        return code;
    }

    private void replaceNames(JCTree.JCExpression expr, int offset) {
        expr.accept(new NameReplacer(this._javacTask, offset));
    }

    private static class EscapeMatcher
    implements IntPredicate {
        private final ManDiagnosticHandler _manDiagnosticHandler;
        private final int _offsetOfLiteral;
        private int _escapedCount;

        private EscapeMatcher(ManDiagnosticHandler manDiagnosticHandler, int offsetOfLiteral) {
            this._manDiagnosticHandler = manDiagnosticHandler;
            this._offsetOfLiteral = offsetOfLiteral;
        }

        @Override
        public boolean test(int index) {
            if (this._manDiagnosticHandler.isEscapedPos(this._offsetOfLiteral + index + (this._escapedCount + 1))) {
                ++this._escapedCount;
                return true;
            }
            return false;
        }
    }
}

