/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.sql.query.api.QueryColumn;
import manifold.sql.query.api.QueryTable;
import manifold.sql.query.jdbc.JdbcQueryTable;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.TypeProvider;
import manifold.sql.rt.util.DbUtil;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaTable;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jetbrains.annotations.Nullable;

public class JdbcQueryColumn
implements QueryColumn {
    private final QueryTable _queryTable;
    private final SchemaTable _schemaTable;
    private final SchemaColumn _schemaColumn;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final String _sqlType;
    private final int _size;
    private final int _scale;
    private final int _displaySize;
    private final boolean _isNullable;
    private final boolean _isCurrency;
    private final boolean _isReadOnly;
    private final boolean _isSigned;
    private final String _columnType;

    public JdbcQueryColumn(int colIndex, JdbcQueryTable queryTable, ResultSetMetaData rsMetaData, DatabaseMetaData dbMetadata) throws SQLException {
        this._position = colIndex;
        this._queryTable = queryTable;
        this._name = DbUtil.handleAnonQueryColumn((String)rsMetaData.getColumnLabel(colIndex), (int)colIndex);
        String tableName = this.getTableName(rsMetaData);
        this._schemaTable = tableName == null || tableName.isEmpty() ? null : this._queryTable.getSchema().getTable(tableName);
        SchemaColumn schemaColumn = this._schemaColumn = this._schemaTable == null ? null : this._schemaTable.getColumn(rsMetaData.getColumnName(colIndex));
        if (this._schemaColumn != null) {
            this._jdbcType = this._schemaColumn.getJdbcType();
            this._sqlType = this._schemaColumn.getSqlType();
            this._columnType = this._schemaColumn.getColumnClassName();
        } else {
            TypeProvider typeProvider = Dependencies.instance().getTypeProvider();
            this._jdbcType = typeProvider.getQueryColumnType(colIndex, rsMetaData, dbMetadata);
            this._sqlType = rsMetaData.getColumnTypeName(colIndex);
            this._columnType = rsMetaData.getColumnClassName(colIndex);
        }
        this._isNullable = rsMetaData.isNullable(colIndex) == 1;
        this._size = rsMetaData.getPrecision(colIndex);
        this._scale = rsMetaData.getScale(colIndex);
        this._displaySize = rsMetaData.getColumnDisplaySize(colIndex);
        this._isCurrency = rsMetaData.isCurrency(colIndex);
        this._isReadOnly = rsMetaData.isReadOnly(colIndex);
        this._isSigned = rsMetaData.isSigned(colIndex);
    }

    @Nullable
    private String getTableName(ResultSetMetaData rsMetaData) {
        String tableName = null;
        try {
            tableName = rsMetaData.getTableName(this.getPosition());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tableName == null || tableName.isEmpty()) {
            tableName = this.parseTableName();
        }
        return tableName;
    }

    private String parseTableName() {
        try {
            PlainSelect select;
            SelectItem selectItem;
            Expression expr;
            Set tables = TablesNamesFinder.findTables((String)this._queryTable.getSqlSource());
            if (tables.size() == 1) {
                String tableName = (String)tables.iterator().next();
                SchemaTable schemaTable = this.getSchemaTable(tableName);
                if (schemaTable != null && schemaTable.getColumn(this._name) != null) {
                    return schemaTable.getName();
                }
            } else if (!tables.isEmpty() && (expr = (selectItem = (select = (PlainSelect)CCJSqlParserUtil.parse((String)this._queryTable.getSqlSource())).getSelectItem(this.getPosition() - 1)).getExpression()) instanceof Column) {
                SchemaTable schemaTable;
                String tableName;
                Table table = ((Column)expr).getTable();
                String string = tableName = table == null ? null : table.getName();
                if (tableName != null && (schemaTable = this.getSchemaTable(tableName)) != null) {
                    return schemaTable.getName();
                }
                if (this._name.equalsIgnoreCase(((Column)expr).getColumnName())) {
                    return this.findColumnInTables(this._name, tables);
                }
                LOGGER.error("Column '" + this._name + "' does not match selectItem: '" + ((Column)expr).getColumnName() + "'");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to find table name for column: '" + this._name + "'");
        }
        return null;
    }

    private String findColumnInTables(String columnName, Set<String> tables) {
        List result = tables.stream().filter(t -> {
            SchemaTable schemaTable = this.getSchemaTable((String)t);
            return schemaTable != null && schemaTable.getColumn(columnName) != null;
        }).collect(Collectors.toList());
        if (result.size() == 1) {
            return (String)result.get(0);
        }
        return null;
    }

    private SchemaTable getSchemaTable(String tableName) {
        SchemaTable table = this._queryTable.getSchema().getTable(tableName);
        if (table == null) {
            tableName = tableName.toLowerCase();
            table = this._queryTable.getSchema().getTable(tableName);
            if (table == null) {
                tableName = tableName.toUpperCase();
                table = this._queryTable.getSchema().getTable(tableName);
            }
        }
        return table;
    }

    @Override
    public QueryTable getOwner() {
        return this._queryTable;
    }

    @Override
    public SchemaTable getSchemaTable() {
        return this._schemaTable;
    }

    public int getJdbcType() {
        return this._jdbcType;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getColumnClassName() {
        return this._columnType;
    }

    @Override
    public SchemaColumn getSchemaColumn() {
        return this._schemaColumn;
    }

    public int getPosition() {
        return this._position;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    public int getSize() {
        return this._size;
    }

    public int getScale() {
        return this._scale;
    }

    @Override
    public QueryTable getQueryTable() {
        return this._queryTable;
    }

    @Override
    public int getDisplaySize() {
        return this._displaySize;
    }

    @Override
    public boolean isCurrency() {
        return this._isCurrency;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    @Override
    public boolean isSigned() {
        return this._isSigned;
    }
}

