/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.rt.api.util.Pair;
import manifold.sql.api.Table;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;

public interface SchemaTable
extends Table {
    public SchemaColumn getId();

    public Map<SchemaTable, List<SchemaForeignKey>> getForeignKeys();

    public List<SchemaColumn> getPrimaryKey();

    public Map<String, List<SchemaColumn>> getNonNullUniqueKeys();

    public String getDescription();

    public Kind getKind();

    public Map<String, SchemaColumn> getColumns();

    @Override
    public SchemaColumn getColumn(String var1);

    public void resolveForeignKeys();

    public void resolveFkRelations();

    public List<SchemaColumn> getNonNullColumns();

    public Set<SchemaForeignKey> getOneToMany();

    public Set<Pair<SchemaColumn, SchemaColumn>> getManyToMany();

    public static enum Kind {
        Table,
        View,
        System;


        public static Kind get(String kind) {
            switch (kind) {
                case "VIEW": {
                    return View;
                }
                case "SYSTEM TABLE": {
                    return System;
                }
            }
            return Table;
        }
    }
}

