/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import manifold.rt.api.util.Pair;
import manifold.sql.api.Parameter;
import manifold.sql.api.Statement;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.TypeProvider;

public class JdbcParameter<S extends Statement>
implements Parameter {
    private final S _owner;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final String _sqlType;
    private final int _size;
    private final int _scale;
    private final boolean _isNullable;
    private final boolean _isSigned;
    private final String _javaClassNameForGetObject;

    public JdbcParameter(int paramIndex, String name, S owner, ParameterMetaData paramMetaData, DatabaseMetaData metaData) throws SQLException {
        String javaClassNameForGetObject;
        boolean isSigned;
        boolean isNullable;
        int scale;
        int size;
        String sqlType;
        this._position = paramIndex;
        this._name = name == null ? "p" + paramIndex : name;
        this._owner = owner;
        Pair<Integer, Boolean> types = this.getJdbcType(paramMetaData, paramIndex, metaData);
        this._jdbcType = (Integer)types.getFirst();
        boolean isFlakyDriver = (Boolean)types.getSecond();
        if (isFlakyDriver) {
            sqlType = "varchar";
            size = 0;
            scale = 0;
            isNullable = true;
            isSigned = true;
            javaClassNameForGetObject = Object.class.getTypeName();
        } else {
            sqlType = paramMetaData.getParameterTypeName(paramIndex);
            size = paramMetaData.getPrecision(paramIndex);
            scale = paramMetaData.getScale(paramIndex);
            isNullable = paramMetaData.isNullable(paramIndex) != 0;
            isSigned = paramMetaData.isSigned(paramIndex);
            javaClassNameForGetObject = paramMetaData.getParameterClassName(paramIndex);
        }
        this._sqlType = sqlType;
        this._size = size;
        this._scale = scale;
        this._isNullable = isNullable;
        this._isSigned = isSigned;
        this._javaClassNameForGetObject = javaClassNameForGetObject;
    }

    private Pair<Integer, Boolean> getJdbcType(ParameterMetaData paramMetaData, int paramIndex, DatabaseMetaData dbMetadata) {
        int jdbcType;
        boolean isFlakyDriver = false;
        try {
            TypeProvider typeProvider = Dependencies.instance().getTypeProvider();
            jdbcType = typeProvider.getQueryParameterType(paramIndex, paramMetaData, dbMetadata);
        }
        catch (SQLException se) {
            jdbcType = 1111;
            isFlakyDriver = true;
        }
        return new Pair((Object)jdbcType, (Object)isFlakyDriver);
    }

    public int getJdbcType() {
        return this._jdbcType;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getColumnClassName() {
        return this._javaClassNameForGetObject;
    }

    public S getOwner() {
        return this._owner;
    }

    public int getPosition() {
        return this._position;
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._size;
    }

    public int getScale() {
        return this._scale;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    @Override
    public boolean isSigned() {
        return this._isSigned;
    }

    public boolean canBeNull() {
        return this.isNullable();
    }
}

