/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.rt.api.util.Pair;
import manifold.sql.query.type.SqlIssueContainer;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.jdbc.JdbcForeignKeyMetadata;
import manifold.sql.schema.jdbc.JdbcSchema;
import manifold.sql.schema.jdbc.JdbcSchemaColumn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSchemaTable
implements SchemaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSchemaTable.class);
    private final JdbcSchema _schema;
    private final String _name;
    private final String _description;
    private final String _tableDdl;
    private final SchemaTable.Kind _kind;
    private final Map<String, SchemaColumn> _columns;
    private final JdbcSchemaColumn _nonNullUniqueId;
    private final ArrayList<SchemaColumn> _primaryKeys;
    private final Map<String, List<SchemaColumn>> _nonNullUniqueKeys;
    private final JdbcForeignKeyMetadata _foreignKeyData;
    private final Map<SchemaTable, List<SchemaForeignKey>> _foreignKeys;
    private final Set<SchemaForeignKey> _oneToMany;
    private final Set<Pair<SchemaColumn, SchemaColumn>> _manyToMany;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSchemaTable(JdbcSchema owner, DatabaseMetaData metaData, ResultSet resultSet) throws SQLException {
        Object columnName;
        this._schema = owner;
        this._name = resultSet.getString("TABLE_NAME");
        this._description = resultSet.getString("REMARKS");
        this._kind = SchemaTable.Kind.get(resultSet.getString("TABLE_TYPE"));
        if (this._kind == null) {
            throw new IllegalStateException("Unexpected table kind for: " + this._name);
        }
        ArrayList<String> primaryKey = new ArrayList<String>();
        String catalogName = this._schema.getDbConfig().getCatalogName();
        String schemaName = this._schema.getName();
        try (ResultSet primaryKeys = metaData.getPrimaryKeys(catalogName, schemaName, this._name);){
            while (primaryKeys.next()) {
                columnName = primaryKeys.getString("COLUMN_NAME");
                primaryKey.add((String)columnName);
            }
        }
        LinkedHashMap<String, Set<String>> uniqueKeys = new LinkedHashMap<String, Set<String>>();
        ResultSet indexInfo = metaData.getIndexInfo(catalogName, schemaName, this._name, true, true);
        columnName = null;
        try {
            while (indexInfo.next()) {
                String indexName;
                if (indexInfo.getBoolean("NON_UNIQUE") || (indexName = indexInfo.getString("INDEX_NAME")) == null) continue;
                uniqueKeys.computeIfAbsent(indexName, __ -> new LinkedHashSet()).add(indexInfo.getString("COLUMN_NAME"));
            }
        }
        catch (Throwable indexName) {
            columnName = indexName;
            throw indexName;
        }
        finally {
            if (indexInfo != null) {
                if (columnName != null) {
                    try {
                        indexInfo.close();
                    }
                    catch (Throwable indexName) {
                        ((Throwable)columnName).addSuppressed(indexName);
                    }
                } else {
                    indexInfo.close();
                }
            }
        }
        ResultSet foreignKeys = metaData.getImportedKeys(catalogName, schemaName, this._name);
        columnName = null;
        try {
            ArrayList<JdbcForeignKeyMetadata.KeyPart> keyParts = new ArrayList<JdbcForeignKeyMetadata.KeyPart>();
            while (foreignKeys.next()) {
                String fkName = foreignKeys.getString("FK_NAME");
                String fkColumnName = foreignKeys.getString("FKCOLUMN_NAME");
                String pkColumnName = foreignKeys.getString("PKCOLUMN_NAME");
                String pkTableName = foreignKeys.getString("PKTABLE_NAME");
                keyParts.add(new JdbcForeignKeyMetadata.KeyPart(fkName, fkColumnName, pkColumnName, pkTableName));
            }
            this._foreignKeyData = new JdbcForeignKeyMetadata(this, keyParts);
        }
        catch (Throwable keyParts) {
            columnName = keyParts;
            throw keyParts;
        }
        finally {
            if (foreignKeys != null) {
                if (columnName != null) {
                    try {
                        foreignKeys.close();
                    }
                    catch (Throwable keyParts) {
                        ((Throwable)columnName).addSuppressed(keyParts);
                    }
                } else {
                    foreignKeys.close();
                }
            }
        }
        this._columns = new LinkedHashMap<String, SchemaColumn>();
        this._primaryKeys = new ArrayList();
        this._foreignKeys = new LinkedHashMap<SchemaTable, List<SchemaForeignKey>>();
        this._nonNullUniqueKeys = new LinkedHashMap<String, List<SchemaColumn>>();
        this._oneToMany = new LinkedHashSet<SchemaForeignKey>();
        this._manyToMany = new LinkedHashSet<Pair<SchemaColumn, SchemaColumn>>();
        this._tableDdl = null;
        List<String> columnClassNames = this.getColumnClassNames(metaData);
        DriverInfo driver = DriverInfo.lookup((DatabaseMetaData)metaData);
        if (schemaName != null && !schemaName.isEmpty() && driver == DriverInfo.Oracle) {
            metaData.getConnection().setSchema(metaData.getUserName());
        }
        try (ResultSet colResults = metaData.getColumns(catalogName, schemaName, this._name, null);){
            int i = 0;
            JdbcSchemaColumn id = null;
            while (colResults.next()) {
                JdbcSchemaColumn col = new JdbcSchemaColumn(++i, this, colResults, primaryKey, uniqueKeys, columnClassNames.get(i - 1), metaData);
                this._columns.put(col.getName(), col);
                if (col.isNonNullUniqueId() && (id == null || id.isPrimaryKeyPart())) {
                    id = col;
                }
                if (col.isPrimaryKeyPart()) {
                    this._primaryKeys.add(col);
                }
                this.buildNonNullUniqueKeys(col);
            }
            this._nonNullUniqueId = id;
        }
        finally {
            if (schemaName != null && !schemaName.isEmpty() && driver == DriverInfo.Oracle) {
                metaData.getConnection().setSchema(schemaName);
            }
        }
    }

    @NotNull
    private List<String> getColumnClassNames(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> columnClassNames = new ArrayList<String>();
        try (PreparedStatement preparedStatement = metaData.getConnection().prepareStatement("select * from " + this._name);){
            int columnCount = preparedStatement.getMetaData().getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                try {
                    columnClassNames.add(preparedStatement.getMetaData().getColumnClassName(i + 1));
                    continue;
                }
                catch (SQLException se) {
                    LOGGER.warn("getColumnClassName() failed.", (Throwable)se);
                    columnClassNames.add(Object.class.getName());
                }
            }
        }
        return columnClassNames;
    }

    private void buildNonNullUniqueKeys(JdbcSchemaColumn col) {
        String nonNullUniqueKeyName = col.getNonNullUniqueKeyName();
        if (nonNullUniqueKeyName != null) {
            this._nonNullUniqueKeys.computeIfAbsent(nonNullUniqueKeyName, __ -> new ArrayList()).add(col);
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String keyName : this._nonNullUniqueKeys.keySet()) {
            List<SchemaColumn> cols = this._nonNullUniqueKeys.get(keyName);
            for (SchemaColumn schemaColumn : cols) {
                if (!schemaColumn.isNullable()) continue;
                removeKeys.add(keyName);
                break;
            }
            if (removeKeys.contains(keyName) || !cols.stream().allMatch(c -> c.isPrimaryKeyPart())) continue;
            removeKeys.add(keyName);
        }
        removeKeys.forEach(key -> this._nonNullUniqueKeys.remove(key));
    }

    @Override
    public JdbcSchema getSchema() {
        return this._schema;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SchemaTable.Kind getKind() {
        return this._kind;
    }

    @Override
    public Map<String, SchemaColumn> getColumns() {
        return this._columns;
    }

    @Override
    public SchemaColumn getColumn(String columnName) {
        return this._columns.get(columnName);
    }

    @Override
    public JdbcSchemaColumn getId() {
        return this._nonNullUniqueId;
    }

    @Override
    public Map<SchemaTable, List<SchemaForeignKey>> getForeignKeys() {
        return this._foreignKeys;
    }

    @Override
    public List<SchemaColumn> getPrimaryKey() {
        return this._primaryKeys;
    }

    @Override
    public Map<String, List<SchemaColumn>> getNonNullUniqueKeys() {
        return this._nonNullUniqueKeys;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getSqlSource() {
        return this._tableDdl;
    }

    @Override
    public SqlIssueContainer getIssues() {
        return null;
    }

    @Override
    public void resolveForeignKeys() {
        this._foreignKeys.putAll(this._foreignKeyData.resolve(this._schema));
    }

    @Override
    public void resolveFkRelations() {
        for (List<SchemaForeignKey> fkDefs : this._foreignKeys.values()) {
            for (SchemaForeignKey fkDef : fkDefs) {
                JdbcSchemaTable referencedTable = (JdbcSchemaTable)fkDef.getReferencedTable();
                List<SchemaColumn> fkColumns = fkDef.getColumns();
                if (!fkColumns.stream().noneMatch(c -> c.isNonNullUniqueId())) continue;
                Pair<SchemaColumn, SchemaColumn> manyToManyKey = this.getManyToManyKey(fkDef);
                if (manyToManyKey != null) {
                    referencedTable._manyToMany.add(manyToManyKey);
                    continue;
                }
                referencedTable._oneToMany.add(fkDef);
            }
        }
    }

    private Pair<SchemaColumn, SchemaColumn> getManyToManyKey(SchemaForeignKey fkDef) {
        List<SchemaColumn> pk = this.getPrimaryKey();
        if (this.isManyToMany(fkDef, pk)) {
            return new Pair((Object)pk.get(0), (Object)pk.get(1));
        }
        for (List<SchemaColumn> ukColumns : this.getNonNullUniqueKeys().values()) {
            if (!this.isManyToMany(fkDef, ukColumns)) continue;
            return new Pair((Object)ukColumns.get(0), (Object)ukColumns.get(1));
        }
        return null;
    }

    private boolean isManyToMany(SchemaForeignKey sfk, List<SchemaColumn> pkColumns) {
        List<SchemaColumn> fkColumns = sfk.getColumns();
        return pkColumns.size() > fkColumns.size() && pkColumns.containsAll(fkColumns) && pkColumns.stream().allMatch(c -> c.getForeignKey() != null) && pkColumns.size() == 2 && pkColumns.get(0).getForeignKey().getOwner() != pkColumns.get(1).getForeignKey().getOwner();
    }

    @Override
    public Set<SchemaForeignKey> getOneToMany() {
        return this._oneToMany;
    }

    @Override
    public Set<Pair<SchemaColumn, SchemaColumn>> getManyToMany() {
        return this._manyToMany;
    }

    @Override
    public List<SchemaColumn> getNonNullColumns() {
        return this.getColumns().values().stream().filter(c -> !c.isNullable()).collect(Collectors.toList());
    }
}

