/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.sql.query.type.SqlModel;
import manifold.sql.query.type.SqlScopeFinder;

public class SqlManifold
extends JavaTypeManifold<SqlModel> {
    public static final List<String> EXTS = Collections.singletonList("sql");
    private SqlScopeFinder _scopeFinder;

    public void init(IModule module) {
        this._scopeFinder = new SqlScopeFinder(module);
        this.init(module, (fqn, files) -> new SqlModel(this, (String)fqn, (Set<IFile>)files));
    }

    public SqlScopeFinder getScopeFinder() {
        return this._scopeFinder;
    }

    public boolean handlesFileExtension(String fileExtension) {
        return EXTS.contains(fileExtension);
    }

    public String getTypeNameForFile(String fqn, IFile file) {
        String fileBaseName = file.getBaseName();
        int contentExt = fileBaseName.lastIndexOf(46);
        if (contentExt < 0) {
            return fqn;
        }
        int indexContentExt = fqn.lastIndexOf(95);
        if (fqn.substring(indexContentExt + 1).equals(fileBaseName.substring(contentExt + 1))) {
            return fqn.substring(0, indexContentExt);
        }
        return fqn;
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        return false;
    }

    public <R> R findByModel(Function<SqlModel, R> byModel) {
        return this.getAllTypeNames().stream().map(fqn -> {
            SqlModel model = this.getModel((String)fqn);
            return model == null ? null : byModel.apply(model);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <R> Stream<R> findAllByModel(Function<SqlModel, R> byModel) {
        return this.getAllTypeNames().stream().map(fqn -> {
            SqlModel model = this.getModel((String)fqn);
            return model == null ? null : byModel.apply(model);
        }).filter(Objects::nonNull);
    }

    protected SqlModel getModel(String fqn) {
        return (SqlModel)super.getModel(fqn);
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, SqlModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        if (!model.getScope().hasConfigErrors()) {
            model.getType().render(sb, location, this.getModule(), errorHandler);
        }
        model.report(errorHandler);
        return sb.toString();
    }
}

